/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class ChainGearshiftBlock extends Internal.ChainDriveBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.KineticBlockEntity>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.KineticBlockEntity;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.KineticBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.KineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly POWERED: Internal.BooleanProperty;
    }
    type ChainGearshiftBlock_ = ChainGearshiftBlock;
    interface ItemBuilder$ReleaseUsingCallback {
        abstract releaseUsing(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_, arg3: number): void;
        (arg0: Internal.ItemStack, arg1: Internal.Level, arg2: Internal.LivingEntity, arg3: number): void;
    }
    type ItemBuilder$ReleaseUsingCallback_ = ItemBuilder$ReleaseUsingCallback;
    interface WatchKey {
        abstract isValid(): boolean;
        abstract pollEvents(): Internal.List<Internal.WatchEvent<any>>;
        abstract watchable(): Internal.Watchable;
        abstract reset(): boolean;
        abstract cancel(): void;
        get valid(): boolean
    }
    type WatchKey_ = WatchKey;
    class PlayerEvents$XpChange extends Internal.PlayerEvents {
        constructor(player: Internal.Player_, amount: number)
        setAmount(amount: number): void;
        getEntity(): Internal.LivingEntity;
        getAmount(): number;
        set amount(amount: number)
        get entity(): Internal.LivingEntity
        get amount(): number
    }
    type PlayerEvents$XpChange_ = PlayerEvents$XpChange;
    interface ServerPlayerKJS extends Internal.PlayerKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getSpawnLocation(): Internal.BlockContainerJS;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        setSpawnLocation(c: Internal.BlockContainerJS_): void;
        captureInventory(autoRestore: boolean): net.minecraft.world.Container;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        openGUI(gui: Internal.Consumer_<Internal.KubeJSGUI>): void;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isOp(): boolean;
        kick(): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        paint(renderer: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        getFoodLevel(): number;
        openChestGUI(title: net.minecraft.network.chat.Component_, rows: number, gui: Internal.Consumer_<Internal.ChestMenuData>): void;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getCraftingGrid(): Internal.InventoryKJS;
        setXpLevel(l: number): void;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setXp(xp: number): void;
        setCreativeMode(mode: boolean): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        notify(builder: Notification_): void;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        isMonster(): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        self(): Internal.ServerPlayer;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        ban(banner: string, reason: string, expiresInMillis: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        revokeAdvancement(id: ResourceLocation_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        kick(reason: net.minecraft.network.chat.Component_): void;
        isAdvancementDone(id: ResourceLocation_): boolean;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        unlockAdvancement(id: ResourceLocation_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        abstract getData(): Internal.AttachedData<Internal.Player>;
        openInventoryGUI(inventory: Internal.InventoryKJS_, title: net.minecraft.network.chat.Component_): void;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get spawnLocation(): Internal.BlockContainerJS
        get offHandItem(): Internal.ItemStack
        set spawnLocation(c: Internal.BlockContainerJS_)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get op(): boolean
        get totalMovementSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get craftingGrid(): Internal.InventoryKJS
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        set creativeMode(mode: boolean)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        (): Internal.AttachedData_<Internal.Player>;
    }
    type ServerPlayerKJS_ = ServerPlayerKJS;
    class TrackTargetingBehaviour$RenderedTrackOverlayType extends Internal.Enum<Internal.TrackTargetingBehaviour$RenderedTrackOverlayType> {
        static valueOf(name: string): Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static values(): Internal.TrackTargetingBehaviour$RenderedTrackOverlayType[];
        static readonly STATION: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly SIGNAL: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly DUAL_SIGNAL: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
        static readonly OBSERVER: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType;
    }
    type TrackTargetingBehaviour$RenderedTrackOverlayType_ = "dual_signal" | TrackTargetingBehaviour$RenderedTrackOverlayType | "signal" | "station" | "observer";
    class ServerStatus extends Internal.Record {
        constructor($$0: net.minecraft.network.chat.Component_, $$1: Internal.Optional_<Internal.ServerStatus$Players>, $$2: Internal.Optional_<Internal.ServerStatus$Version>, $$3: Internal.Optional_<Internal.ServerStatus$Favicon>, $$4: boolean)
        description(): net.minecraft.network.chat.Component;
        enforcesSecureChat(): boolean;
        favicon(): Internal.Optional<Internal.ServerStatus$Favicon>;
        version(): Internal.Optional<Internal.ServerStatus$Version>;
        players(): Internal.Optional<Internal.ServerStatus$Players>;
        static readonly CODEC: Internal.Codec<Internal.ServerStatus>;
    }
    type ServerStatus_ = ServerStatus;
    class TrackShapeLookup$GenericCrossingData extends Internal.Record {
        constructor(merged: net.createmod.catnip.data.Pair_<Internal.TrackShape, boolean>, existingMaterial: Internal.TrackMaterial_, overlayMaterial: Internal.TrackMaterial_)
        overlayMaterial(): Internal.TrackMaterial;
        existingMaterial(): Internal.TrackMaterial;
        merged(): net.createmod.catnip.data.Pair<Internal.TrackShape, boolean>;
    }
    type TrackShapeLookup$GenericCrossingData_ = TrackShapeLookup$GenericCrossingData;
    interface PocketHolder {
        abstract isValid(arg0: Internal.ServerComputer_): boolean;
        isTerminalAlwaysVisible(): boolean;
        abstract level(): Internal.ServerLevel;
        abstract blockPos(): BlockPos;
        abstract setChanged(): void;
        abstract pos(): Vec3d;
        get terminalAlwaysVisible(): boolean
    }
    type PocketHolder_ = PocketHolder;
    class ElevatorContactBlock extends Internal.WrenchableDirectionalBlock implements Internal.IBE<Internal.ElevatorContactBlockEntity>, Internal.WeakPowerCheckingBlock, Internal.ConnectableRedstoneBlock, Internal.SpecialBlockItemRequirement {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static getColumnCoords(level: Internal.LevelAccessor_, pos: BlockPos_): Internal.ElevatorColumn$ColumnCoords;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ElevatorContactBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ElevatorContactBlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ElevatorContactBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        callToContactAndUpdate(elevatorColumn: Internal.ElevatorColumn_, pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_, powered: boolean): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ElevatorContactBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        scheduleActivation(pLevel: Internal.LevelAccessor_, pPos: BlockPos_): void;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ElevatorContactBlockEntity>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.ElevatorContactBlockEntity;
        static getLight(state: Internal.BlockState_): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.ElevatorContactBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.ElevatorContactBlockEntity
        static readonly POWERING: Internal.BooleanProperty;
        static readonly CALLING: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type ElevatorContactBlock_ = ElevatorContactBlock;
    class SpawnStymphalianBird extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(configFactoryIn: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SpawnStymphalianBird_ = SpawnStymphalianBird;
    abstract class PlayerEvents extends Internal.LivingEntityEvents {
        constructor(player: Internal.Player_)
        getPlayer(): Internal.Player;
        get player(): Internal.Player
        static readonly LOGGED_OUT: net.fabricmc.fabric.api.event.Event<Internal.PlayerEvents$PlayerLoggedInOrOut>;
        static readonly XP_CHANGE: net.fabricmc.fabric.api.event.Event<Internal.PlayerEvents$PlayerXpChange>;
        static readonly LOGGED_IN: net.fabricmc.fabric.api.event.Event<Internal.PlayerEvents$PlayerLoggedInOrOut>;
        static readonly PICKUP_XP: net.fabricmc.fabric.api.event.Event<Internal.PlayerEvents$PlayerXpPickUp>;
        static readonly BREAK_SPEED: net.fabricmc.fabric.api.event.Event<Internal.PlayerEvents$PlayerBreakSpeed>;
    }
    type PlayerEvents_ = PlayerEvents;
    interface FileAttributeView extends Internal.AttributeView {
        abstract name(): string;
        (): string;
    }
    type FileAttributeView_ = FileAttributeView;
    interface NbtAccounterAccessor {
        abstract create$getUsage(): number;
        (): number;
    }
    type NbtAccounterAccessor_ = NbtAccounterAccessor;
    interface DensityFunction$FunctionContext {
        abstract blockX(): number;
        getBlender(): Internal.Blender;
        abstract blockZ(): number;
        abstract blockY(): number;
        get blender(): Internal.Blender
    }
    type DensityFunction$FunctionContext_ = DensityFunction$FunctionContext;
    abstract class BaseComponent implements io.wispforest.owo.ui.core.Component {
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        horizontalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        x(): number;
        charTyped(): Internal.EventSource<Internal.CharTyped>;
        horizontalSizing(horizontalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        updateX(x: number): void;
        mouseLeave(): Internal.EventSource<Internal.MouseLeave>;
        update(delta: number, mouseX: number, mouseY: number): void;
        verticalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        remove(): void;
        hasParent(): boolean;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        onFocusGained(source: Internal.Component$FocusSource_): void;
        abstract draw(arg0: Internal.OwoUIDrawContext_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        height(): number;
        positioning(positioning: Internal.Positioning_): this;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        onCharTyped(chr: string, modifiers: number): boolean;
        focusLost(): Internal.EventSource<Internal.FocusLost>;
        focusHandler(): Internal.FocusHandler;
        id(): string;
        margins(): Internal.AnimatableProperty<io.wispforest.owo.ui.core.Insets>;
        onMouseUp(mouseX: number, mouseY: number, button: number): boolean;
        configure<C extends io.wispforest.owo.ui.core.Component>(closure: Internal.Consumer_<C>): C;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        tooltip(tooltip: Internal.List_<Internal.ClientTooltipComponent>): io.wispforest.owo.ui.core.Component;
        onMouseScroll(mouseX: number, mouseY: number, amount: number): boolean;
        inflate(space: Internal.Size_): void;
        width(): number;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        mouseUp(): Internal.EventSource<Internal.MouseUp>;
        root(): Internal.ParentComponent;
        onKeyPress(keyCode: number, scanCode: number, modifiers: number): boolean;
        parent(): Internal.ParentComponent;
        cursorStyle(): Internal.CursorStyle;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        shouldDrawTooltip(mouseX: number, mouseY: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        keyPress(): Internal.EventSource<Internal.KeyPress>;
        y(): number;
        id(id: string): io.wispforest.owo.ui.core.Component;
        mouseEnter(): Internal.EventSource<Internal.MouseEnter>;
        updateY(y: number): void;
        moveTo(x: number, y: number): void;
        isInBoundingBox(x: number, y: number): boolean;
        fullSize(): Internal.Size;
        mouseDown(): Internal.EventSource<Internal.MouseDown>;
        onMouseDrag(mouseX: number, mouseY: number, deltaX: number, deltaY: number, button: number): boolean;
        zIndex(): number;
        zIndex(zIndex: number): io.wispforest.owo.ui.core.Component;
        onMouseDown(mouseX: number, mouseY: number, button: number): boolean;
        parseProperties(model: Internal.UIModel_, element: Internal.Element_, children: Internal.Map_<string, Internal.Element>): void;
        mouseScroll(): Internal.EventSource<Internal.MouseScroll>;
        focusGained(): Internal.EventSource<Internal.FocusGained>;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        onFocusLost(): void;
        mount(parent: Internal.ParentComponent_, x: number, y: number): void;
        mouseDrag(): Internal.EventSource<Internal.MouseDrag>;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        tooltip(): Internal.List<Internal.ClientTooltipComponent>;
        verticalSizing(verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        cursorStyle(arg0: Internal.CursorStyle_): io.wispforest.owo.ui.core.Component;
        canFocus(source: Internal.Component$FocusSource_): boolean;
        positioning(): Internal.AnimatableProperty<Internal.Positioning>;
        margins(arg0: io.wispforest.owo.ui.core.Insets_): io.wispforest.owo.ui.core.Component;
        dismount(reason: Internal.Component$DismountReason_): void;
    }
    type BaseComponent_ = BaseComponent;
    class ArmBlock extends Internal.KineticBlock implements Internal.IBE<Internal.ArmBlockEntity>, Internal.ICogWheel {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSmallCog(): boolean;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        isLargeCog(): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ArmBlockEntity;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ArmBlockEntity>;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCogItem(test: Internal.ItemStack_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static isLargeCog(state: Internal.BlockState_): boolean;
        isDedicatedCogWheel(): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityClass(): typeof Internal.ArmBlockEntity;
        static isLargeCogItem(test: Internal.ItemStack_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCog(state: Internal.BlockState_): boolean;
        setRequiresTool(v: boolean): void;
        static isLargeCog(block: Internal.Block_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static isDedicatedCogWheel(block: Internal.Block_): boolean;
        static isSmallCog(block: Internal.Block_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ArmBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static isDedicatedCogItem(test: Internal.ItemStack_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ArmBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ArmBlockEntity>;
        get smallCog(): boolean
        get largeCog(): boolean
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get dedicatedCogWheel(): boolean
        get blockEntityClass(): typeof Internal.ArmBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.ArmBlockEntity>
        static readonly CEILING: Internal.BooleanProperty;
    }
    type ArmBlock_ = ArmBlock;
    class NopProcessor extends Internal.StructureProcessor {
        static readonly CODEC: Internal.Codec<Internal.NopProcessor>;
        static readonly INSTANCE: Internal.NopProcessor;
    }
    type NopProcessor_ = NopProcessor;
    class RandomTickCallbackJS {
        constructor(containerJS: Internal.BlockContainerJS_, random: Internal.RandomSource_)
        getLevel(): Internal.Level;
        getServer(): Internal.MinecraftServer;
        get level(): Internal.Level
        get server(): Internal.MinecraftServer
        block: Internal.BlockContainerJS;
        random: Internal.RandomSource;
    }
    type RandomTickCallbackJS_ = RandomTickCallbackJS;
    /**
     * Invoked after all items are registered to modify them.
    */
    class ItemModificationEventJS extends Internal.EventJS {
        constructor()
        /**
         * Modifies items matching the given ingredient.
         * 
         * **NOTE**: tag ingredients are not supported at this time.
        */
        modify(in_: Internal.Ingredient_, c: Internal.Consumer_<Internal.Item>): void;
    }
    type ItemModificationEventJS_ = ItemModificationEventJS;
    class Dimension extends Internal.Dimension2D implements Internal.Serializable {
        constructor()
        constructor(arg0: number, arg1: number)
        constructor(arg0: Internal.Dimension_)
        getSize(): this;
        setSize(arg0: number, arg1: number): void;
        setSize(arg0: Internal.Dimension_): void;
        get size(): Internal.Dimension
        set size(arg0: Internal.Dimension_)
        width: number;
        height: number;
    }
    type Dimension_ = Dimension;
    class FuelBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_, burnTime: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getBurnTime(stack: Internal.ItemStack_, recipeType: Internal.RecipeType_<any>): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly burnTime: number;
    }
    type FuelBlockItem_ = FuelBlockItem;
    class TrackEdge {
        constructor(node1: Internal.TrackNode_, node2: Internal.TrackNode_, turn: Internal.BezierConnection_, trackMaterial: Internal.TrackMaterial_)
        incrementT(currentT: number, distance: number): number;
        getPositionSmoothed(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        getIntersection(node1: Internal.TrackNode_, node2: Internal.TrackNode_, other: Internal.TrackEdge_, other1: Internal.TrackNode_, other2: Internal.TrackNode_): Internal.Collection<number[]>;
        getDirectionAt(t: number): Vec3d;
        getPosition(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        canTravelTo(other: Internal.TrackEdge_): boolean;
        getTurn(): Internal.BezierConnection;
        isTurn(): boolean;
        getNormalSmoothed(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        getDirection(fromFirst: boolean): Vec3d;
        getNormal(trackGraph: Internal.TrackGraph_, t: number): Vec3d;
        isInterDimensional(): boolean;
        getLength(): number;
        getTrackMaterial(): Internal.TrackMaterial;
        getEdgeData(): Internal.EdgeData;
        static read(node1: Internal.TrackNode_, node2: Internal.TrackNode_, tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): Internal.TrackEdge;
        get turn(): Internal.BezierConnection
        get turn(): boolean
        get interDimensional(): boolean
        get length(): number
        get trackMaterial(): Internal.TrackMaterial
        get edgeData(): Internal.EdgeData
        node1: Internal.TrackNode;
        node2: Internal.TrackNode;
    }
    type TrackEdge_ = TrackEdge;
    interface ExtendedWorld {
        abstract getChunkAtImmediately(arg0: number, arg1: number): Internal.LevelChunk;
        abstract getAnyChunkImmediately(arg0: number, arg1: number): Internal.ChunkAccess;
    }
    type ExtendedWorld_ = ExtendedWorld;
    interface SortedMap <K, V> extends Internal.SequencedMap<K, V> {
        putLast(arg0: K, arg1: V): V;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        lastEntry(): Internal.Map$Entry<K, V>;
        abstract containsValue(arg0: any): boolean;
        abstract tailMap(arg0: K): this;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        abstract comparator(): Internal.Comparator<K>;
        abstract headMap(arg0: K): this;
        putFirst(arg0: K, arg1: V): V;
        abstract get(arg0: any): V;
        sequencedValues(): Internal.SequencedCollection<V>;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        sequencedEntrySet(): Internal.SequencedSet<Internal.Map$Entry<K, V>>;
        abstract subMap(arg0: K, arg1: K): this;
        putIfAbsent(arg0: K, arg1: V): V;
        abstract values(): Internal.Collection<V>;
        abstract entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        firstEntry(): Internal.Map$Entry<K, V>;
        pollFirstEntry(): Internal.Map$Entry<K, V>;
        sequencedKeySet(): Internal.SequencedSet<K>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        reversed(): this;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        pollLastEntry(): Internal.Map$Entry<K, V>;
        replace(arg0: K, arg1: V): V;
        of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        abstract containsKey(arg0: any): boolean;
        abstract put(arg0: K, arg1: V): V;
        abstract remove(arg0: any): V;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        abstract keySet(): Internal.Set<K>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        abstract putAll(arg0: Internal.Map_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        abstract lastKey(): K;
        abstract size(): number;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        abstract clear(): void;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        abstract equals(arg0: any): boolean;
        abstract firstKey(): K;
        get empty(): boolean
    }
    type SortedMap_<K, V> = SortedMap<K, V>;
    class StainedGlassPaneBlock extends Internal.IronBarsBlock implements Internal.BeaconBeamBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
    }
    type StainedGlassPaneBlock_ = StainedGlassPaneBlock;
    class PageAttributes$PrintQualityType extends Internal.AttributeValue {
        static readonly DRAFT: Internal.PageAttributes$PrintQualityType;
        static readonly HIGH: Internal.PageAttributes$PrintQualityType;
        static readonly NORMAL: Internal.PageAttributes$PrintQualityType;
    }
    type PageAttributes$PrintQualityType_ = PageAttributes$PrintQualityType;
    class ServerChunkCache extends Internal.ChunkSource {
        constructor($$0: Internal.ServerLevel_, $$1: Internal.LevelStorageSource$LevelStorageAccess_, $$2: Internal.DataFixer_, $$3: Internal.StructureTemplateManager_, $$4: Internal.Executor_, $$5: Internal.ChunkGenerator_, $$6: number, $$7: number, $$8: boolean, $$9: Internal.ChunkProgressListener_, $$10: any_, $$11: Internal.Supplier_<Internal.DimensionDataStorage>)
        broadcast($$0: Internal.Entity_, $$1: Internal.Packet_<any>): void;
        getDataStorage(): Internal.DimensionDataStorage;
        pollTask(): boolean;
        setSimulationDistance($$0: number): void;
        removeEntity($$0: Internal.Entity_): void;
        getLevel(): Internal.Level;
        getLastSpawnState(): Internal.NaturalSpawner$SpawnState;
        removeRegionTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        getChunkDebugData($$0: Internal.ChunkPos_): string;
        chunkScanner(): Internal.ChunkScanAccess;
        addRegionTicket<T>($$0: Internal.TicketType_<T>, $$1: Internal.ChunkPos_, $$2: number, $$3: T): void;
        setViewDistance($$0: number): void;
        getPendingTasksCount(): number;
        getTickingGenerated(): number;
        randomState(): Internal.RandomState;
        getPoiManager(): Internal.PoiManager;
        broadcastAndSend($$0: Internal.Entity_, $$1: Internal.Packet_<any>): void;
        move($$0: Internal.ServerPlayer_): void;
        getGeneratorState(): Internal.ChunkGeneratorStructureState;
        addEntity($$0: Internal.Entity_): void;
        getLightEngine(): Internal.ThreadedLevelLightEngine;
        isPositionTicking($$0: number): boolean;
        blockChanged($$0: BlockPos_): void;
        getChunkFuture($$0: number, $$1: number, $$2: Internal.ChunkStatus_, $$3: boolean): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getGenerator(): Internal.ChunkGenerator;
        removeTicketsOnClosing(): void;
        save($$0: boolean): void;
        get dataStorage(): Internal.DimensionDataStorage
        set simulationDistance($$0: number)
        get level(): Internal.Level
        get lastSpawnState(): Internal.NaturalSpawner$SpawnState
        set viewDistance($$0: number)
        get pendingTasksCount(): number
        get tickingGenerated(): number
        get poiManager(): Internal.PoiManager
        get generatorState(): Internal.ChunkGeneratorStructureState
        get lightEngine(): Internal.ThreadedLevelLightEngine
        get generator(): Internal.ChunkGenerator
        readonly chunkMap: Internal.ChunkMap;
    }
    type ServerChunkCache_ = ServerChunkCache;
    interface LongList extends Internal.LongCollection, Internal.Comparable<Internal.List<number>>, Internal.List<number> {
        abstract removeLong(arg0: number): number;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        addAll(arg0: Internal.LongList_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        of(...arg0: number[]): this;
        of<E>(arg0: E): Internal.List<E>;
        getFirst(): number;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        replaceAll(arg0: Internal.LongUnaryOperator_): void;
        abstract addAll(arg0: Internal.LongCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        abstract toArray<T>(arg0: T[]): T[];
        replaceAll(arg0: it.unimi.dsi.fastutil.longs.LongUnaryOperator_): void;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        abstract compareTo(arg0: Internal.List_<number>): number;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        sort(arg0: Internal.LongComparator_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        longSpliterator(): Internal.LongSpliterator;
        unstableSort(arg0: Internal.LongComparator_): void;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        abstract iterator(): Internal.LongListIterator;
        setElements(arg0: number[]): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        longIterator(): Internal.LongIterator;
        of(arg0: number): this;
        /**
         * @deprecated
        */
        toLongArray(arg0: number[]): number[];
        abstract toArray(arg0: number[]): number[];
        listIterator(arg0: number): Internal.ListIterator<any>;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        /**
         * @deprecated
        */
        get(arg0: number): any;
        addFirst(arg0: number): void;
        abstract rem(arg0: number): boolean;
        subList(arg0: number, arg1: number): Internal.List<any>;
        abstract size(): number;
        abstract toLongArray(): number[];
        longParallelStream(): Internal.LongStream;
        abstract set(arg0: number, arg1: number): number;
        abstract clear(): void;
        abstract addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        removeIf(arg0: Internal.LongPredicate_): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        addAll(arg0: number, arg1: Internal.LongList_): boolean;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        removeFirst(): number;
        abstract retainAll(arg0: Internal.LongCollection_): boolean;
        listIterator(): Internal.ListIterator<any>;
        forEach(arg0: Internal.LongConsumer_): void;
        abstract size(arg0: number): void;
        abstract add(arg0: number, arg1: number): void;
        abstract addAll(arg0: number, arg1: Internal.LongCollection_): boolean;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        abstract addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        forEach(arg0: it.unimi.dsi.fastutil.longs.LongConsumer_): void;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        abstract removeAll(arg0: Internal.LongCollection_): boolean;
        abstract containsAll(arg0: Internal.LongCollection_): boolean;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        abstract getLong(arg0: number): number;
        of(arg0: number, arg1: number): this;
        addLast(arg0: number): void;
        abstract addElements(arg0: number, arg1: number[]): void;
        abstract indexOf(arg0: number): number;
        abstract removeElements(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        abstract add(arg0: number): boolean;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        abstract isEmpty(): boolean;
        setElements(arg0: number, arg1: number[]): void;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        getLast(): number;
        removeLast(): number;
        of<E>(...arg0: E[]): Internal.List<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        abstract lastIndexOf(arg0: number): number;
        of(arg0: number, arg1: number, arg2: number): this;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        abstract getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        abstract contains(arg0: number): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        abstract toArray(): any[];
        abstract hashCode(): number;
        longStream(): Internal.LongStream;
        abstract equals(arg0: any): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.longs.LongPredicate_): boolean;
        of(): this;
        get first(): number
        set elements(arg0: number[])
        get empty(): boolean
        get last(): number
    }
    type LongList_ = LongList;
    interface Double2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.DoubleFunction<V> {
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Double2ObjectFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2ObjectFunction<V>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Double2LongFunction;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Double2DoubleFunction;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        remove(arg0: number): V;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Double2CharFunction;
        put(arg0: number, arg1: V): V;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2ObjectFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Double2ByteFunction;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Double2ShortFunction;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2ObjectFunction<V>;
        apply(arg0: number): V;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2ObjectFunction<V>;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        abstract get(arg0: number): V;
        containsKey(arg0: number): boolean;
        getOrDefault(arg0: number, arg1: V): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Double2FloatFunction;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2ObjectFunction<V>;
        size(): number;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Double2ReferenceFunction<T>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Double2IntFunction;
        clear(): void;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        defaultReturnValue(): V;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2ObjectFunction<V>;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: number): V;
    }
    type Double2ObjectFunction_<V> = Double2ObjectFunction<V>;
    class AtomicReference <V> implements Internal.Serializable {
        constructor()
        constructor(arg0: V)
        weakCompareAndSetPlain(arg0: V, arg1: V): boolean;
        updateAndGet(arg0: Internal.UnaryOperator_<V>): V;
        getAndSet(arg0: V): V;
        weakCompareAndSetRelease(arg0: V, arg1: V): boolean;
        setPlain(arg0: V): void;
        weakCompareAndSetAcquire(arg0: V, arg1: V): boolean;
        getAndUpdate(arg0: Internal.UnaryOperator_<V>): V;
        getOpaque(): V;
        getAcquire(): V;
        compareAndExchangeAcquire(arg0: V, arg1: V): V;
        weakCompareAndSetVolatile(arg0: V, arg1: V): boolean;
        lazySet(arg0: V): void;
        get(): V;
        setRelease(arg0: V): void;
        compareAndSet(arg0: V, arg1: V): boolean;
        compareAndExchangeRelease(arg0: V, arg1: V): V;
        /**
         * @deprecated
        */
        weakCompareAndSet(arg0: V, arg1: V): boolean;
        setOpaque(arg0: V): void;
        compareAndExchange(arg0: V, arg1: V): V;
        accumulateAndGet(arg0: V, arg1: Internal.BinaryOperator_<V>): V;
        getPlain(): V;
        set(arg0: V): void;
        getAndAccumulate(arg0: V, arg1: Internal.BinaryOperator_<V>): V;
        set plain(arg0: V)
        get opaque(): V
        get acquire(): V
        set release(arg0: V)
        set opaque(arg0: V)
        get plain(): V
    }
    type AtomicReference_<V> = AtomicReference<V>;
    class SerializerType <T> {
        constructor($$0: Internal.Serializer_<T>)
        getSerializer(): Internal.Serializer<T>;
        get serializer(): Internal.Serializer<T>
    }
    type SerializerType_<T> = SerializerType<T>;
    class BlockRenderDispatcher implements Internal.ResourceManagerReloadListener, Internal.BlockRenderDispatcherAccessor, Internal.BlockRenderManagerAccessor, Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.BlockModelShaper_, $$1: Internal.BlockEntityWithoutLevelRenderer_, $$2: Internal.BlockColors_)
        renderSingleBlock($$0: Internal.BlockState_, $$1: Internal.PoseStack_, $$2: Internal.MultiBufferSource_, $$3: number, $$4: number): void;
        onResourceManagerReload($$0: Internal.ResourceManager_): void;
        getBlockModelShaper(): Internal.BlockModelShaper;
        getFabricDependencies(): Internal.Collection<any>;
        getBlockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer;
        getModelRenderer(): Internal.ModelBlockRenderer;
        getBlockModel($$0: Internal.BlockState_): Internal.BakedModel;
        getName(): string;
        renderBreakingTexture($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.BlockAndTintGetter_, $$3: Internal.PoseStack_, $$4: Internal.VertexConsumer_): void;
        renderBatched($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.BlockAndTintGetter_, $$3: Internal.PoseStack_, $$4: Internal.VertexConsumer_, $$5: boolean, $$6: Internal.RandomSource_): void;
        getFabricId(): ResourceLocation;
        renderLiquid($$0: BlockPos_, $$1: Internal.BlockAndTintGetter_, $$2: Internal.VertexConsumer_, $$3: Internal.BlockState_, $$4: Internal.FluidState_): void;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get blockModelShaper(): Internal.BlockModelShaper
        get fabricDependencies(): Internal.Collection<any>
        get blockEntityRenderer(): Internal.BlockEntityWithoutLevelRenderer
        get modelRenderer(): Internal.ModelBlockRenderer
        get name(): string
        get fabricId(): ResourceLocation
    }
    type BlockRenderDispatcher_ = BlockRenderDispatcher;
    class BlueIceFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type BlueIceFeature_ = BlueIceFeature;
    interface AgriGeneMutator <T> {
        abstract pickOrMutate(arg0: Internal.AgriCrop_, arg1: Internal.AgriGene_<T>, arg2: Internal.AgriAllele_<T>, arg3: Internal.AgriAllele_<T>, arg4: Internal.AgriGenome_, arg5: Internal.AgriGenome_, arg6: Internal.RandomSource_): Internal.AgriGenePair<T>;
        (arg0: Internal.AgriCrop, arg1: Internal.AgriGene<T>, arg2: Internal.AgriAllele<T>, arg3: Internal.AgriAllele<T>, arg4: Internal.AgriGenome, arg5: Internal.AgriGenome, arg6: Internal.RandomSource): Internal.AgriGenePair_<T>;
    }
    type AgriGeneMutator_<T> = AgriGeneMutator<T>;
    class ToxicStrikeEnchantment extends Internal.Enchantment {
        constructor()
        registryName(): string;
    }
    type ToxicStrikeEnchantment_ = ToxicStrikeEnchantment;
    class FluidTankBlock$Shape extends Internal.Enum<Internal.FluidTankBlock$Shape> implements Internal.StringRepresentable {
        static values(): Internal.FluidTankBlock$Shape[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.FluidTankBlock$Shape;
        get serializedName(): string
        static readonly WINDOW_SW: Internal.FluidTankBlock$Shape;
        static readonly WINDOW_SE: Internal.FluidTankBlock$Shape;
        static readonly WINDOW_NE: Internal.FluidTankBlock$Shape;
        static readonly PLAIN: Internal.FluidTankBlock$Shape;
        static readonly WINDOW: Internal.FluidTankBlock$Shape;
        static readonly WINDOW_NW: Internal.FluidTankBlock$Shape;
    }
    type FluidTankBlock$Shape_ = FluidTankBlock$Shape | "window_nw" | "window_ne" | "window" | "window_sw" | "plain" | "window_se";
    class ClipContext {
        constructor($$0: Vec3d_, $$1: Vec3d_, $$2: any_, $$3: Internal.ClipContext$Fluid_, $$4: Internal.Entity_)
        getFluidShape($$0: Internal.FluidState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        "handler$edm000$lib39-phantom$lib39Phantom$getFluidShape"(state: Internal.FluidState_, world: Internal.BlockGetter_, pos: BlockPos_, ci: Internal.CallbackInfoReturnable_<any>): void;
        getFrom(): Vec3d;
        getTo(): Vec3d;
        "handler$edm000$lib39-phantom$lib39Phantom$getBlockShape"(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, ci: Internal.CallbackInfoReturnable_<any>): void;
        redirect$dcd000$hexcasting$hex$getCollisionContext(entity: Internal.Entity_): Internal.CollisionContext;
        getBlockShape($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): Internal.VoxelShape;
        get from(): Vec3d
        get to(): Vec3d
    }
    type ClipContext_ = ClipContext;
    class TooltipWidget extends Internal.Widget {
        constructor(tooltipSupplier: Internal.BiFunction_<number, number, Internal.List<Internal.ClientTooltipComponent>>, x: number, y: number, width: number, height: number)
    }
    type TooltipWidget_ = TooltipWidget;
    class WorldBorder {
        constructor()
        getDamagePerBlock(): number;
        getLerpRemainingTime(): number;
        removeListener($$0: Internal.BorderChangeListener_): void;
        getMaxZ(): number;
        clampToBounds($$0: number, $$1: number, $$2: number): BlockPos;
        getMaxX(): number;
        getAbsoluteMaxSize(): number;
        getCenterZ(): number;
        getLerpSpeed(): number;
        getCenterX(): number;
        isWithinBounds($$0: number, $$1: number, $$2: number): boolean;
        setWarningTime($$0: number): void;
        redirect$elo000$lithium$getUpdatedArea(instance: Internal.WorldBorder$BorderExtent_): Internal.WorldBorder$BorderExtent;
        setCenter($$0: number, $$1: number): void;
        getStatus(): Internal.BorderStatus;
        getCollisionShape(): Internal.VoxelShape;
        setDamageSafeZone($$0: number): void;
        getWarningTime(): number;
        setSize($$0: number): void;
        applySettings($$0: Internal.WorldBorder$Settings_): void;
        getMinX(): number;
        getWarningBlocks(): number;
        createSettings(): Internal.WorldBorder$Settings;
        isWithinBounds($$0: Internal.AABB_): boolean;
        getMinZ(): number;
        addListener($$0: Internal.BorderChangeListener_): void;
        getDistanceToBorder($$0: Internal.Entity_): number;
        getDamageSafeZone(): number;
        getSize(): number;
        lerpSizeBetween($$0: number, $$1: number, $$2: number): void;
        tick(): void;
        setDamagePerBlock($$0: number): void;
        getLerpTarget(): number;
        getDistanceToBorder($$0: number, $$1: number): number;
        setAbsoluteMaxSize($$0: number): void;
        isWithinBounds($$0: BlockPos_): boolean;
        isInsideCloseToBorder($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        isWithinBounds($$0: number, $$1: number): boolean;
        isWithinBounds($$0: Internal.ChunkPos_): boolean;
        setWarningBlocks($$0: number): void;
        get damagePerBlock(): number
        get lerpRemainingTime(): number
        get maxZ(): number
        get maxX(): number
        get absoluteMaxSize(): number
        get centerZ(): number
        get lerpSpeed(): number
        get centerX(): number
        set warningTime($$0: number)
        get status(): Internal.BorderStatus
        get collisionShape(): Internal.VoxelShape
        set damageSafeZone($$0: number)
        get warningTime(): number
        set size($$0: number)
        get minX(): number
        get warningBlocks(): number
        get minZ(): number
        get damageSafeZone(): number
        get size(): number
        set damagePerBlock($$0: number)
        get lerpTarget(): number
        set absoluteMaxSize($$0: number)
        set warningBlocks($$0: number)
        static readonly MAX_CENTER_COORDINATE: 2.9999984E7;
        static readonly MAX_SIZE: 5.9999968E7;
        static readonly DEFAULT_SETTINGS: Internal.WorldBorder$Settings;
    }
    type WorldBorder_ = WorldBorder;
    class MediumQuintupleWheelBogeyBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MediumQuintupleWheelBogeyBlock_ = MediumQuintupleWheelBogeyBlock;
    class TrapezoidHeight extends Internal.HeightProvider implements Internal.TrapezoidHeightAccessor {
        getMinInclusive(): Internal.VerticalAnchor;
        static of($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_): Internal.TrapezoidHeight;
        static of($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_, $$2: number): Internal.TrapezoidHeight;
        getPlateau(): number;
        getMaxInclusive(): Internal.VerticalAnchor;
        get minInclusive(): Internal.VerticalAnchor
        get plateau(): number
        get maxInclusive(): Internal.VerticalAnchor
        static readonly CODEC: Internal.Codec<Internal.TrapezoidHeight>;
    }
    type TrapezoidHeight_ = TrapezoidHeight;
    class EnergizingRodTile extends Internal.AbstractEnergyStorage<Internal.EnergyConfig, Internal.EnergizingRodBlock> {
        constructor(pos: BlockPos_, state: Internal.BlockState_)
        constructor(pos: BlockPos_, state: Internal.BlockState_, variant: owmii.powah.block.Tier_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setOrbPos(orbPos: BlockPos_): void;
        getOrbPos(): BlockPos;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getOrbTile(): Internal.EnergizingOrbTile;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        hasOrb(): boolean;
        nextRedstoneMode(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        set orbPos(orbPos: BlockPos_)
        get orbPos(): BlockPos
        get orbTile(): Internal.EnergizingOrbTile
        get renderBoundingBox(): Internal.AABB
        readonly coolDown: Internal.Ticker;
    }
    type EnergizingRodTile_ = EnergizingRodTile;
    class RecipeCollection {
        constructor($$0: Internal.RegistryAccess_, $$1: Internal.List_<Internal.Recipe<any>>)
        hasSingleResultItem(): boolean;
        hasKnownRecipes(): boolean;
        hasFitting(): boolean;
        canCraft($$0: Internal.StackedContents_, $$1: number, $$2: number, $$3: Internal.RecipeBook_): void;
        registryAccess(): Internal.RegistryAccess;
        hasCraftable(): boolean;
        getRecipes($$0: boolean): Internal.List<Internal.Recipe<any>>;
        getDisplayRecipes($$0: boolean): Internal.List<Internal.Recipe<any>>;
        isCraftable($$0: Internal.Recipe_<any>): boolean;
        getRecipes(): Internal.List<Internal.Recipe<any>>;
        updateKnownRecipes($$0: Internal.RecipeBook_): void;
        get recipes(): Internal.List<Internal.Recipe<any>>
    }
    type RecipeCollection_ = RecipeCollection;
    class GateIota$EntityAnchor extends Internal.Record {
        constructor(uuid: Internal.UUID_, name: string, offset: Vec3d_)
        name(): string;
        offset(): Vec3d;
        uuid(): Internal.UUID;
    }
    type GateIota$EntityAnchor_ = GateIota$EntityAnchor;
    abstract class OutputStream implements Internal.Closeable, Internal.Flushable {
        constructor()
        flush(): void;
        abstract write(arg0: number): void;
        static nullOutputStream(): Internal.OutputStream;
        close(): void;
        write(arg0: number[], arg1: number, arg2: number): void;
        write(arg0: number[]): void;
    }
    type OutputStream_ = OutputStream;
    class CookingPotBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock, Internal.EntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntity: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly SUPPORT: Internal.EnumProperty<Internal.CookingPotSupport>;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type CookingPotBlock_ = CookingPotBlock;
    class BlockFishbig extends Internal.AEBaseBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockFishbig_ = BlockFishbig;
    class ClientboundSetBorderWarningDistancePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.WorldBorder_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getWarningBlocks(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get warningBlocks(): number
        get skippable(): boolean
    }
    type ClientboundSetBorderWarningDistancePacket_ = ClientboundSetBorderWarningDistancePacket;
    interface ParticleAccessor {
        abstract port_lib$stoppedByCollision(arg0: boolean): void;
        (arg0: boolean): void;
    }
    type ParticleAccessor_ = ParticleAccessor;
    class RailShape extends Internal.Enum<Internal.RailShape> implements Internal.StringRepresentable {
        static values(): Internal.RailShape[];
        isAscending(): boolean;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        getName(): string;
        static valueOf($$0: string): Internal.RailShape;
        get ascending(): boolean
        get serializedName(): string
        get name(): string
        static readonly NORTH_EAST: Internal.RailShape;
        static readonly NORTH_WEST: Internal.RailShape;
        static readonly SOUTH_EAST: Internal.RailShape;
        static readonly ASCENDING_WEST: Internal.RailShape;
        static readonly ASCENDING_EAST: Internal.RailShape;
        static readonly ASCENDING_NORTH: Internal.RailShape;
        static readonly ASCENDING_SOUTH: Internal.RailShape;
        static readonly NORTH_SOUTH: Internal.RailShape;
        static readonly EAST_WEST: Internal.RailShape;
        static readonly SOUTH_WEST: Internal.RailShape;
    }
    type RailShape_ = "north_west" | "north_east" | "ascending_west" | "south_west" | "ascending_east" | RailShape | "north_south" | "east_west" | "ascending_south" | "ascending_north" | "south_east";
    interface IFilteredUpgrade {
        abstract getFilterLogic(): Internal.FilterLogic;
        get filterLogic(): Internal.FilterLogic
        (): Internal.FilterLogic_;
    }
    type IFilteredUpgrade_ = IFilteredUpgrade;
    class Display$ItemDisplay extends Internal.Display {
        constructor($$0: Internal.EntityType_<any>, $$1: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        itemRenderState(): Internal.Display$ItemDisplay$ItemRenderState;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getItemStack(): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        get itemStack(): Internal.ItemStack
    }
    type Display$ItemDisplay_ = Display$ItemDisplay;
    class BloodBlock extends Internal.LiquidBlock implements Internal.BucketPickup {
        constructor(p_54694_: Internal.FlowingFluid_, p_54695_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static callInit(fluid: Internal.FlowingFluid_, settings: Internal.BlockBehaviour$Properties_): Internal.LiquidBlock;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        arch$getFluid(): Internal.FlowingFluid;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BloodBlock_ = BloodBlock;
    interface MaterialView {
        abstract emissive(): boolean;
        abstract disableDiffuse(): boolean;
        abstract ambientOcclusion(): Internal.TriState;
        abstract glint(): Internal.TriState;
        abstract disableColorIndex(): boolean;
        abstract blendMode(): net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
    }
    type MaterialView_ = MaterialView;
    class CombinedSlottedStackStorage <S extends Internal.SlottedStackStorage> extends Internal.CombinedSlottedStorage<Internal.ItemVariant, S> implements Internal.SlottedStackStorage {
        constructor(parts: Internal.List_<S>)
        constructor(...parts: S[])
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        getSlotLimit(slot: number): number;
        isItemValid(slot: number, resource: Internal.ItemVariant_, count: number): boolean;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        getStackInSlot(slot: number): Internal.ItemStack;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
    }
    type CombinedSlottedStackStorage_<S extends Internal.SlottedStackStorage> = CombinedSlottedStackStorage<S>;
    class TrackNode {
        constructor(location: Internal.TrackNodeLocation_, netId: number, normal: Vec3d_)
        getNetId(): number;
        getNormal(): Vec3d;
        getLocation(): Internal.TrackNodeLocation;
        get netId(): number
        get normal(): Vec3d
        get location(): Internal.TrackNodeLocation
    }
    type TrackNode_ = TrackNode;
    class MillstoneBlock extends Internal.KineticBlock implements Internal.ICogWheel, Internal.IBE<Internal.MillstoneBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.MillstoneBlockEntity>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.MillstoneBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSmallCog(): boolean;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        isLargeCog(): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.MillstoneBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCogItem(test: Internal.ItemStack_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static isLargeCog(state: Internal.BlockState_): boolean;
        isDedicatedCogWheel(): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static isLargeCogItem(test: Internal.ItemStack_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static isSmallCog(state: Internal.BlockState_): boolean;
        setRequiresTool(v: boolean): void;
        static isLargeCog(block: Internal.Block_): boolean;
        getBlockEntityClass(): typeof Internal.MillstoneBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static isDedicatedCogWheel(block: Internal.Block_): boolean;
        static isSmallCog(block: Internal.Block_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.MillstoneBlockEntity>): void;
        showCapacityWithAnnotation(): boolean;
        static isDedicatedCogItem(test: Internal.ItemStack_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.MillstoneBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        emi(amount: number): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.MillstoneBlockEntity>
        get smallCog(): boolean
        get largeCog(): boolean
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get dedicatedCogWheel(): boolean
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.MillstoneBlockEntity
        get mod(): string
    }
    type MillstoneBlock_ = MillstoneBlock;
    interface PackSource {
        create($$0: Internal.UnaryOperator_<net.minecraft.network.chat.Component>, $$1: boolean): this;
        abstract shouldAddAutomatically(): boolean;
        abstract decorate(arg0: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        readonly NO_DECORATION: Internal.UnaryOperator<net.minecraft.network.chat.Component>;
        readonly FEATURE: Internal.PackSource;
        readonly DEFAULT: Internal.PackSource;
        readonly SERVER: Internal.PackSource;
        readonly BUILT_IN: Internal.PackSource;
        readonly WORLD: Internal.PackSource;
    }
    type PackSource_ = PackSource;
    abstract class AbstractMemorySegmentImpl implements Internal.MemorySegment, Internal.SegmentAllocator, Internal.BiFunction<string, Internal.List<number>, Internal.RuntimeException> {
        toArray(arg0: Internal.ValueLayout$OfByte_): number[];
        spliterator(arg0: Internal.MemoryLayout_): Internal.Spliterator<Internal.MemorySegment>;
        abstract heapBase(): Internal.Optional<any>;
        setAtIndex(arg0: Internal.AddressLayout_, arg1: number, arg2: Internal.MemorySegment_): void;
        sessionImpl(): Internal.MemorySessionImpl;
        getAtIndex(arg0: Internal.ValueLayout$OfFloat_, arg1: number): number;
        allocateArray(arg0: Internal.ValueLayout$OfDouble_, ...arg1: number[]): Internal.MemorySegment;
        set(arg0: Internal.ValueLayout$OfBoolean_, arg1: number, arg2: boolean): void;
        get(arg0: Internal.ValueLayout$OfInt_, arg1: number): number;
        allocate(arg0: Internal.ValueLayout$OfFloat_, arg1: number): Internal.MemorySegment;
        setAtIndex(arg0: Internal.ValueLayout$OfFloat_, arg1: number, arg2: number): void;
        setAtIndex(arg0: Internal.ValueLayout$OfShort_, arg1: number, arg2: number): void;
        abstract unsafeGetBase(): any;
        static copy(arg0: Internal.MemorySegment_, arg1: number, arg2: Internal.MemorySegment_, arg3: number, arg4: number): void;
        get(arg0: Internal.ValueLayout$OfLong_, arg1: number): number;
        get(arg0: Internal.ValueLayout$OfChar_, arg1: number): string;
        static mismatch(arg0: Internal.MemorySegment_, arg1: number, arg2: number, arg3: Internal.MemorySegment_, arg4: number, arg5: number): number;
        static vectorizedMismatchLargeForBytes(arg0: Internal.MemorySessionImpl_, arg1: Internal.MemorySessionImpl_, arg2: any, arg3: number, arg4: any, arg5: number, arg6: number): number;
        byteSize(): number;
        set(arg0: Internal.ValueLayout$OfByte_, arg1: number, arg2: number): void;
        setAtIndex(arg0: Internal.ValueLayout$OfInt_, arg1: number, arg2: number): void;
        setUtf8String(arg0: number, arg1: string): void;
        setAtIndex(arg0: Internal.ValueLayout$OfLong_, arg1: number, arg2: number): void;
        allocateArray(arg0: Internal.MemoryLayout_, arg1: number): Internal.MemorySegment;
        fill(arg0: number): Internal.MemorySegment;
        isReadOnly(): boolean;
        get(arg0: Internal.ValueLayout$OfDouble_, arg1: number): number;
        getUtf8String(arg0: number): string;
        elements(arg0: Internal.MemoryLayout_): Internal.Stream<Internal.MemorySegment>;
        abstract unsafeGetOffset(): number;
        abstract maxAlignMask(): number;
        static ofArray(arg0: number[]): Internal.MemorySegment;
        isLoaded(): boolean;
        allocate(arg0: Internal.ValueLayout$OfLong_, arg1: number): Internal.MemorySegment;
        allocate(arg0: number, arg1: number): Internal.MemorySegment;
        reinterpretInternal(arg0: typeof any, arg1: number, arg2: Internal.MemorySegment$Scope_, arg3: Internal.Consumer_<Internal.MemorySegment>): Internal.MemorySegment;
        get(arg0: Internal.ValueLayout$OfByte_, arg1: number): number;
        setAtIndex(arg0: Internal.ValueLayout$OfBoolean_, arg1: number, arg2: boolean): void;
        allocateUtf8String(arg0: string): Internal.MemorySegment;
        set(arg0: Internal.ValueLayout$OfFloat_, arg1: number, arg2: number): void;
        andThen<V>(arg0: Internal.Function_<Internal.RuntimeException, V>): Internal.BiFunction<string, Internal.List<number>, V>;
        isAlignedForElement(arg0: number, arg1: number): boolean;
        toArray(arg0: Internal.ValueLayout$OfShort_): number[];
        load(): void;
        static prefixAllocator(arg0: Internal.MemorySegment_): Internal.SegmentAllocator;
        abstract address(): number;
        allocate(arg0: Internal.ValueLayout$OfDouble_, arg1: number): Internal.MemorySegment;
        toArray(arg0: Internal.ValueLayout$OfDouble_): number[];
        allocateArray(arg0: Internal.ValueLayout$OfChar_, ...arg1: string[]): Internal.MemorySegment;
        getAtIndex(arg0: Internal.ValueLayout$OfLong_, arg1: number): number;
        static copy(arg0: any, arg1: number, arg2: Internal.MemorySegment_, arg3: Internal.ValueLayout_, arg4: number, arg5: number): void;
        setAtIndex(arg0: Internal.ValueLayout$OfDouble_, arg1: number, arg2: number): void;
        allocateArray(arg0: Internal.ValueLayout$OfByte_, ...arg1: number[]): Internal.MemorySegment;
        setAtIndex(arg0: Internal.ValueLayout$OfByte_, arg1: number, arg2: number): void;
        toArray(arg0: Internal.ValueLayout$OfInt_): number[];
        toArray(arg0: Internal.ValueLayout$OfLong_): number[];
        allocate(arg0: Internal.ValueLayout$OfShort_, arg1: number): Internal.MemorySegment;
        reinterpret(arg0: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfInt_, ...arg1: number[]): Internal.MemorySegment;
        get(arg0: Internal.AddressLayout_, arg1: number): Internal.MemorySegment;
        apply(arg0: string, arg1: Internal.List_<number>): Internal.RuntimeException;
        asSlice(arg0: number): Internal.MemorySegment;
        reinterpret(arg0: number, arg1: Internal.Arena_, arg2: Internal.Consumer_<Internal.MemorySegment>): Internal.MemorySegment;
        segmentOffset(arg0: Internal.MemorySegment_): number;
        allocateArray(arg0: Internal.ValueLayout$OfShort_, ...arg1: number[]): Internal.MemorySegment;
        asSlice(arg0: number, arg1: number, arg2: number): Internal.MemorySegment;
        getAtIndex(arg0: Internal.AddressLayout_, arg1: number): Internal.MemorySegment;
        allocate(arg0: Internal.AddressLayout_, arg1: Internal.MemorySegment_): Internal.MemorySegment;
        force(): void;
        static ofAddress(arg0: number): Internal.MemorySegment;
        static slicingAllocator(arg0: Internal.MemorySegment_): Internal.SegmentAllocator;
        getAtIndex(arg0: Internal.ValueLayout$OfDouble_, arg1: number): number;
        asSlice(arg0: number, arg1: Internal.MemoryLayout_): Internal.MemorySegment;
        isAlignedForElement(arg0: number, arg1: Internal.MemoryLayout_): boolean;
        static ofArray(arg0: number[]): Internal.MemorySegment;
        toArray(arg0: Internal.ValueLayout$OfFloat_): number[];
        isMapped(): boolean;
        setAtIndex(arg0: Internal.ValueLayout$OfChar_, arg1: number, arg2: string): void;
        static copy(arg0: Internal.MemorySegment_, arg1: Internal.ValueLayout_, arg2: number, arg3: any, arg4: number, arg5: number): void;
        allocate(arg0: Internal.MemoryLayout_): Internal.MemorySegment;
        asReadOnly(): this;
        get(arg0: Internal.ValueLayout$OfFloat_, arg1: number): number;
        getAtIndex(arg0: Internal.ValueLayout$OfInt_, arg1: number): number;
        getAtIndex(arg0: Internal.ValueLayout$OfShort_, arg1: number): number;
        reinterpret(arg0: Internal.Arena_, arg1: Internal.Consumer_<Internal.MemorySegment>): Internal.MemorySegment;
        static ofArray(arg0: string[]): Internal.MemorySegment;
        get(arg0: Internal.ValueLayout$OfBoolean_, arg1: number): boolean;
        set(arg0: Internal.AddressLayout_, arg1: number, arg2: Internal.MemorySegment_): void;
        static ofArray(arg0: number[]): Internal.MemorySegment;
        getAtIndex(arg0: Internal.ValueLayout$OfByte_, arg1: number): number;
        static copy(arg0: Internal.MemorySegment_, arg1: Internal.ValueLayout_, arg2: number, arg3: Internal.MemorySegment_, arg4: Internal.ValueLayout_, arg5: number, arg6: number): void;
        get(arg0: Internal.ValueLayout$OfShort_, arg1: number): number;
        toArray(arg0: Internal.ValueLayout$OfChar_): string[];
        checkValidState(): void;
        set(arg0: Internal.ValueLayout$OfShort_, arg1: number, arg2: number): void;
        asByteBuffer(): Internal.ByteBuffer;
        copyFrom(arg0: Internal.MemorySegment_): Internal.MemorySegment;
        isAccessibleBy(arg0: Internal.Thread_): boolean;
        set(arg0: Internal.ValueLayout$OfInt_, arg1: number, arg2: number): void;
        unload(): void;
        asOverlappingSlice(arg0: Internal.MemorySegment_): Internal.Optional<Internal.MemorySegment>;
        set(arg0: Internal.ValueLayout$OfDouble_, arg1: number, arg2: number): void;
        static ofBuffer(arg0: Internal.Buffer_): Internal.AbstractMemorySegmentImpl;
        getAtIndex(arg0: Internal.ValueLayout$OfBoolean_, arg1: number): boolean;
        static ofArray(arg0: number[]): Internal.MemorySegment;
        apply(arg0: any, arg1: any): any;
        isNative(): boolean;
        set(arg0: Internal.ValueLayout$OfChar_, arg1: number, arg2: string): void;
        allocate(arg0: Internal.ValueLayout$OfInt_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfFloat_, ...arg1: number[]): Internal.MemorySegment;
        getAtIndex(arg0: Internal.ValueLayout$OfChar_, arg1: number): string;
        scope(): Internal.MemorySegment$Scope;
        checkAccess(arg0: number, arg1: number, arg2: boolean): void;
        static ofArray(arg0: number[]): Internal.MemorySegment;
        asSlice(arg0: number, arg1: number): Internal.MemorySegment;
        set(arg0: Internal.ValueLayout$OfLong_, arg1: number, arg2: number): void;
        allocate(arg0: Internal.ValueLayout$OfChar_, arg1: string): Internal.MemorySegment;
        static ofArray(arg0: number[]): Internal.MemorySegment;
        allocate(arg0: Internal.ValueLayout$OfByte_, arg1: number): Internal.MemorySegment;
        allocateArray(arg0: Internal.ValueLayout$OfLong_, ...arg1: number[]): Internal.MemorySegment;
        allocate(arg0: number): Internal.MemorySegment;
        mismatch(arg0: Internal.MemorySegment_): number;
        get readOnly(): boolean
        get loaded(): boolean
        get mapped(): boolean
        get "native"(): boolean
    }
    type AbstractMemorySegmentImpl_ = AbstractMemorySegmentImpl;
    interface PehkuiBlockStateExtensions {
        abstract pehkui_getOutlineShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        abstract pehkui_getBlock(): Internal.Block;
    }
    type PehkuiBlockStateExtensions_ = PehkuiBlockStateExtensions;
    class ExcavatingRecipe$Serializer <T extends Internal.ExcavatingRecipe> implements Internal.RecipeSerializer<T> {
        constructor(type: any_<any>, create: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(pRecipeId: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromNetwork(pRecipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): T;
        toJson(recipe: T, json: Internal.JsonObject_): void;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: T): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type ExcavatingRecipe$Serializer_<T extends Internal.ExcavatingRecipe> = ExcavatingRecipe$Serializer<T>;
    interface IIOFilterUpgrade {
        abstract getInputFilter(): Internal.Optional<Internal.FilterLogic>;
        abstract getOutputFilter(): Internal.Optional<Internal.FilterLogic>;
        get inputFilter(): Internal.Optional<Internal.FilterLogic>
        get outputFilter(): Internal.Optional<Internal.FilterLogic>
    }
    type IIOFilterUpgrade_ = IIOFilterUpgrade;
    class Display$TextDisplay$Align extends Internal.Enum<Internal.Display$TextDisplay$Align> implements Internal.StringRepresentable {
        static values(): Internal.Display$TextDisplay$Align[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Display$TextDisplay$Align;
        get serializedName(): string
        static readonly LEFT: Internal.Display$TextDisplay$Align;
        static readonly CODEC: Internal.Codec<Internal.Display$TextDisplay$Align>;
        static readonly CENTER: Internal.Display$TextDisplay$Align;
        static readonly RIGHT: Internal.Display$TextDisplay$Align;
    }
    type Display$TextDisplay$Align_ = "center" | "right" | Display$TextDisplay$Align | "left";
    class AestheticGravestoneBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AestheticGravestoneBlockItem_ = AestheticGravestoneBlockItem;
    class ServerStatsCounter extends Internal.StatsCounter {
        constructor($$0: Internal.MinecraftServer_, $$1: Internal.File_)
        parseLocal($$0: Internal.DataFixer_, $$1: string): void;
        sendStats($$0: Internal.ServerPlayer_): void;
        markAllDirty(): void;
        save(): void;
    }
    type ServerStatsCounter_ = ServerStatsCounter;
    class FluidTankBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation, Internal.SidedStorageBlockEntity, Internal.CustomRenderBoundingBoxBlockEntity, Internal.IMultiBlockEntityContainer$Fluid {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        setTankSize(tank: number, blocks: number): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setController(controller: BlockPos_): void;
        getTankInventory(): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getTank(tank: number): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
        queueConnectivityUpdate(): void;
        static getMaxHeight(): number;
        preventConnectivityUpdate(): void;
        getTankSize(tank: number): number;
        onLoad(): void;
        getOtherFluidTankBlockEntity(direction: Internal.Direction_): this;
        static getCapacityMultiplier(): number;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getFluid(tank: number): Internal.FluidStack;
        hasTank(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        getWidth(): number;
        modifyExtraData(data: any): any;
        asComponentProvider(): Internal.ComponentProvider;
        updateBoilerTemperature(): void;
        getController(): BlockPos;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setWindows(window: boolean): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getFluidLevel(): Internal.LerpedFloat;
        getMainConnectionAxis(): Internal.Direction$Axis;
        getRenderBoundingBox(): Internal.AABB;
        removeController(keepFluids: boolean): void;
        isController(): boolean;
        setExtraData(data: any): void;
        sendDataImmediately(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getLastKnownPos(): BlockPos;
        getFluidStorage(direction: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTotalTankSize(): number;
        applyFluidTankSize(blocks: number): void;
        setFluidLevel(fluidLevel: Internal.LerpedFloat_): void;
        notifyMultiUpdated(): void;
        getExtraData(): any;
        getControllerBE(): this;
        setWidth(width: number): void;
        getHeight(): number;
        getMaxLength(longAxis: Internal.Direction$Axis_, width: number): number;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        getMaxWidth(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        static getMaxSize(): number;
        updateBoilerState(): void;
        getInfiniteBoundingBox(): Internal.AABB;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getFillState(): number;
        toggleWindows(): void;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        setHeight(height: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        set controller(controller: BlockPos_)
        get tankInventory(): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank
        get maxHeight(): number
        get capacityMultiplier(): number
        get width(): number
        get controller(): BlockPos
        set windows(window: boolean)
        get fluidLevel(): Internal.LerpedFloat
        get mainConnectionAxis(): Internal.Direction$Axis
        get renderBoundingBox(): Internal.AABB
        get controller(): boolean
        set extraData(data: any)
        get lastKnownPos(): BlockPos
        get totalTankSize(): number
        set fluidLevel(fluidLevel: Internal.LerpedFloat_)
        get extraData(): any
        get controllerBE(): Internal.FluidTankBlockEntity
        set width(width: number)
        get height(): number
        get maxWidth(): number
        get maxSize(): number
        get infiniteBoundingBox(): Internal.AABB
        get fillState(): number
        set height(height: number)
        boiler: Internal.BoilerData;
    }
    type FluidTankBlockEntity_ = FluidTankBlockEntity;
    class NetherPortalBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type NetherPortalBlock_ = NetherPortalBlock;
    class GameProfileCache$GameProfileInfo {
        getLastAccess(): number;
        getProfile(): Internal.GameProfile;
        setLastAccess($$0: number): void;
        getExpirationDate(): Internal.Date;
        get lastAccess(): number
        get profile(): Internal.GameProfile
        set lastAccess($$0: number)
        get expirationDate(): Internal.Date
    }
    type GameProfileCache$GameProfileInfo_ = GameProfileCache$GameProfileInfo;
    class AcaciaFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.AcaciaFoliagePlacer>;
    }
    type AcaciaFoliagePlacer_ = AcaciaFoliagePlacer;
    interface ConfigCallback {
        abstract save(arg0: boolean): void;
        (arg0: boolean): void;
    }
    type ConfigCallback_ = ConfigCallback;
    class TransformRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(id: ResourceLocation_, ingredients: Internal.NonNullList_<Internal.Ingredient>, output: Internal.ItemStack_, circumstance: Internal.TransformCircumstance_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(container: net.minecraft.world.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        matches(container: net.minecraft.world.Container_, level: Internal.Level_): boolean;
        getResultItem(): Internal.ItemStack;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get resultItem(): Internal.ItemStack
        get mod(): string
        readonly output: Internal.ItemStack;
        static readonly TYPE: Internal.RecipeType$1;
        readonly ingredients: Internal.NonNullList<Internal.Ingredient>;
        readonly circumstance: Internal.TransformCircumstance;
        static readonly TYPE_ID: ResourceLocation;
    }
    type TransformRecipe_ = TransformRecipe;
    class FilterLogic$ObservableFilterItemStackHandler extends Internal.FilterItemStackHandler {
        constructor(this$0: Internal.FilterLogic_)
        supportsExtraction(): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsInsertion(): boolean;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        serializeNBT(): Internal.Tag;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        static asClass<T>(): Internal.Storage<T>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        setOnSlotChange(onSlotChange: Internal.IntConsumer_): void;
        get version(): number
        set onSlotChange(onSlotChange: Internal.IntConsumer_)
    }
    type FilterLogic$ObservableFilterItemStackHandler_ = FilterLogic$ObservableFilterItemStackHandler;
    abstract class AbstractBogeyBlock <T extends Internal.AbstractBogeyBlockEntity> extends Internal.Block implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<T>, Internal.SpecialBlockItemRequirement {
        constructor(pProperties: Internal.BlockBehaviour$Properties_, size: Internal.BogeySizes$BogeySize_)
        allowsSingleBogeyCarriage(): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRequiredItems(state: Internal.BlockState_, te: Internal.BlockEntity_): Internal.ItemRequirement;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): T;
        isUpsideDown(state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<T>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getVersion(base: Internal.BlockState_, upsideDown: boolean): Internal.BlockState;
        isOnIncompatibleTrack(carriage: Internal.Carriage_, leading: boolean): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<T>;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getNextStyle(level: Internal.Level_, pos: BlockPos_): Internal.BogeyStyle;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getStateOfSize(sbbe: Internal.AbstractBogeyBlockEntity_, size: Internal.BogeySizes$BogeySize_): Internal.BlockState;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getStickySurfaces(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Internal.EnumSet<Internal.Direction>;
        getValidPathfindingTypes(style: Internal.BogeyStyle_): Internal.Set<Internal.TrackMaterial$TrackType>;
        getNextSize(sbbe: Internal.AbstractBogeyBlockEntity_): Internal.BlockState;
        abstract getBlockEntityType(): Internal.BlockEntityType<T>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        abstract getWheelRadius(): number;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        abstract getTrackType(arg0: Internal.BogeyStyle_): Internal.TrackMaterial$TrackType;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<T, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static registerStandardBogey(block: ResourceLocation_): void;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        abstract getBlockEntityClass(): T;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getConnectorAnchorOffset(upsideDown: boolean): Vec3d;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        getNextStyle(style: Internal.BogeyStyle_): Internal.BogeyStyle;
        isTrackAxisAlongFirstCoordinate(state: Internal.BlockState_): boolean;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(state: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        abstract getWheelPointSpacing(): number;
        getMatchingBogey(upDirection: Internal.Direction_, axisAlongFirst: boolean): Internal.BlockState;
        abstract getDefaultStyle(): Internal.BogeyStyle;
        getSize(): Internal.BogeySizes$BogeySize;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        propertiesToCopy(): Internal.List<Internal.Property<any>>;
        captureBlockEntityForTrain(): boolean;
        getNextSize(level: Internal.Level_, pos: BlockPos_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        canBeUpsideDown(): boolean;
        getBogeyUpDirection(): Internal.Direction;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<T>
        get wheelRadius(): number
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityClass(): T
        set requiresTool(v: boolean)
        get mod(): string
        get wheelPointSpacing(): number
        get defaultStyle(): Internal.BogeyStyle
        get size(): Internal.BogeySizes$BogeySize
        get bogeyUpDirection(): Internal.Direction
        size: Internal.BogeySizes$BogeySize;
        static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    }
    type AbstractBogeyBlock_<T extends Internal.AbstractBogeyBlockEntity> = AbstractBogeyBlock<T>;
    abstract class FastMapKey <T extends Internal.Comparable<T>> {
        getProperty(): Internal.Property<T>;
        abstract getValue(arg0: number): T;
        numValues(): number;
        get property(): Internal.Property<T>
    }
    type FastMapKey_<T extends Internal.Comparable<T>> = FastMapKey<T>;
    abstract class GlslPreprocessor {
        constructor()
        process($$0: string): Internal.List<string>;
        abstract applyImport(arg0: boolean, arg1: string): string;
    }
    type GlslPreprocessor_ = GlslPreprocessor;
    class HoverEvent$ItemStackInfo {
        constructor($$0: Internal.ItemStack_)
        getItemStack(): Internal.ItemStack;
        get itemStack(): Internal.ItemStack
    }
    type HoverEvent$ItemStackInfo_ = HoverEvent$ItemStackInfo;
    interface AccessorBlockEntityType {
        abstract setValidBlocks(arg0: Internal.Set_<Internal.Block>): void;
        abstract getValidBlocks(): Internal.Set<Internal.Block>;
        set validBlocks(arg0: Internal.Set_<Internal.Block>)
        get validBlocks(): Internal.Set<Internal.Block>
    }
    type AccessorBlockEntityType_ = AccessorBlockEntityType;
    interface StructLayout extends Internal.GroupLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        withName(arg0: string): Internal.GroupLayout;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): this;
        abstract hashCode(): number;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        withoutName(): Internal.GroupLayout;
        abstract equals(arg0: any): boolean;
        abstract memberLayouts(): Internal.List<Internal.MemoryLayout>;
    }
    type StructLayout_ = StructLayout;
    class HandcarItem extends Internal.BlockItem implements Internal.IDeployAnywayBlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        placeHandcar(trackGraphLocation: Internal.TrackGraphLocation_, level: Internal.Level_, player: Internal.Player_, soundPos: BlockPos_): boolean;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static withGraphLocation(level: Internal.Level_, pos: BlockPos_, front: boolean, targetBezier: Internal.BezierTrackPointLocation_, callback: Internal.BiConsumer_<Internal.TrackTargetingBlockItem$OverlapResult, Internal.TrackGraphLocation>): void;
        emi(amount: number): Internal.EmiStack;
        useOnCurve(selection: Internal.TrackBlockOutline$BezierPointSelection_, stack: Internal.ItemStack_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HandcarItem_ = HandcarItem;
    class ClientboundSetCameraPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntity($$0: Internal.Level_): Internal.Entity;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundSetCameraPacket_ = ClientboundSetCameraPacket;
    abstract class EnumSet <E extends Internal.Enum<E>> extends Internal.AbstractSet<E> implements Internal.Cloneable, Internal.Serializable {
        static of<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        parallelStream(): Internal.Stream<E>;
        static copyOf<E extends Internal.Enum<E>>(arg0: Internal.Collection_<E>): Internal.EnumSet<E>;
        static allOf<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        static noneOf<E extends Internal.Enum<E>>(arg0: E): Internal.EnumSet<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        clone(): this;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, ...arg1: E[]): Internal.EnumSet<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E): Internal.EnumSet<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.EnumSet<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static complementOf<E extends Internal.Enum<E>>(arg0: Internal.EnumSet_<E>): Internal.EnumSet<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.EnumSet<E>;
        static of<E extends Internal.Enum<E>>(arg0: E, arg1: E, arg2: E): Internal.EnumSet<E>;
        abstract iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        stream(): Internal.Stream<E>;
        static copyOf<E extends Internal.Enum<E>>(arg0: Internal.EnumSet_<E>): Internal.EnumSet<E>;
        static range<E extends Internal.Enum<E>>(arg0: E, arg1: E): Internal.EnumSet<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        spliterator(): Internal.Spliterator<E>;
    }
    type EnumSet_<E extends Internal.Enum<E>> = EnumSet<E>;
    class BeehiveBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        emptyAllLivingFromHive($$0: Internal.Player_, $$1: Internal.BlockState_, $$2: Internal.BeehiveBlockEntity$BeeReleaseStatus_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BeehiveBlockEntity_): void;
        isFireNearby(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        storeBee($$0: Internal.CompoundTag_, $$1: number, $$2: boolean): void;
        writeBees(): Internal.ListTag;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getOccupantCount(): number;
        invalidateCaps(): void;
        static getHoneyLevel($$0: Internal.BlockState_): number;
        isFull(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        isSedated(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        addOccupantWithPresetTicks($$0: Internal.Entity_, $$1: boolean, $$2: number): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addOccupant($$0: Internal.Entity_, $$1: boolean): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get empty(): boolean
        get fireNearby(): boolean
        get occupantCount(): number
        get full(): boolean
        get sedated(): boolean
        static readonly TICKS_IN_HIVE: "TicksInHive";
        static readonly BEES: "Bees";
        static readonly HAS_NECTAR: "HasNectar";
        static readonly TAG_FLOWER_POS: "FlowerPos";
        static readonly MIN_OCCUPATION_TICKS_NECTARLESS: 600;
        static readonly MIN_OCCUPATION_TICKS: "MinOccupationTicks";
        static readonly ENTITY_DATA: "EntityData";
        static readonly MAX_OCCUPANTS: 3;
    }
    type BeehiveBlockEntity_ = BeehiveBlockEntity;
    interface LithiumInventory extends net.minecraft.world.Container {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        abstract isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        abstract removeItem(arg0: number, arg1: number): Internal.ItemStack;
        getSlots(): number;
        abstract setInventoryLithium(arg0: Internal.NonNullList_<Internal.ItemStack>): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        abstract setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        abstract getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        abstract setItem(arg0: number, arg1: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        abstract getInventoryLithium(): Internal.NonNullList<Internal.ItemStack>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        abstract removeItemNoUpdate(arg0: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract stillValid(arg0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        abstract getItem(arg0: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        abstract clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        set inventoryLithium(arg0: Internal.NonNullList_<Internal.ItemStack>)
        get containerSize(): number
        get height(): number
        get inventoryLithium(): Internal.NonNullList<Internal.ItemStack>
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type LithiumInventory_ = LithiumInventory;
    class Type$FieldNotFoundException extends Internal.Type$TypeError {
        constructor(arg0: string)
    }
    type Type$FieldNotFoundException_ = Type$FieldNotFoundException;
    class ArmorItemBuilder$Boots extends Internal.ArmorItemBuilder {
        constructor(i: ResourceLocation_)
        createObject(): any;
    }
    type ArmorItemBuilder$Boots_ = ArmorItemBuilder$Boots;
    interface RuleBlockEntityModifierType <P extends Internal.RuleBlockEntityModifier> {
        abstract codec(): Internal.Codec<P>;
        (): Internal.Codec_<P>;
        readonly PASSTHROUGH: Internal.RuleBlockEntityModifierType<Internal.Passthrough>;
        readonly CLEAR: Internal.RuleBlockEntityModifierType<Internal.Clear>;
        readonly APPEND_LOOT: Internal.RuleBlockEntityModifierType<Internal.AppendLoot>;
        readonly APPEND_STATIC: Internal.RuleBlockEntityModifierType<Internal.AppendStatic>;
    }
    type RuleBlockEntityModifierType_<P extends Internal.RuleBlockEntityModifier> = RuleBlockEntityModifierType<P> | Special.RuleBlockEntityModifier;
    interface IFacadePart {
        abstract getTextureItem(): Internal.ItemStack;
        abstract getBlockState(): Internal.BlockState;
        abstract getBoxes(arg0: Internal.IPartCollisionHelper_, arg1: boolean): void;
        abstract getItem(): Internal.Item;
        abstract getSide(): Internal.Direction;
        abstract getItemStack(): Internal.ItemStack;
        get textureItem(): Internal.ItemStack
        get blockState(): Internal.BlockState
        get item(): Internal.Item
        get side(): Internal.Direction
        get itemStack(): Internal.ItemStack
    }
    type IFacadePart_ = IFacadePart;
    interface EntitySwingListenerItem {
        abstract onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        (arg0: Internal.ItemStack, arg1: Internal.LivingEntity): boolean;
    }
    type EntitySwingListenerItem_ = EntitySwingListenerItem;
    interface ProfilerFiller {
        abstract markForCharting(arg0: Internal.MetricCategory_): void;
        abstract push(arg0: Internal.Supplier_<string>): void;
        abstract incrementCounter(arg0: string, arg1: number): void;
        tee($$0: Internal.ProfilerFiller_, $$1: Internal.ProfilerFiller_): this;
        abstract popPush(arg0: string): void;
        abstract push(arg0: string): void;
        incrementCounter($$0: Internal.Supplier_<string>): void;
        abstract pop(): void;
        abstract incrementCounter(arg0: Internal.Supplier_<string>, arg1: number): void;
        incrementCounter($$0: string): void;
        abstract endTick(): void;
        abstract popPush(arg0: Internal.Supplier_<string>): void;
        abstract startTick(): void;
        readonly ROOT: "root";
    }
    type ProfilerFiller_ = ProfilerFiller;
    interface DoubleList extends Internal.DoubleCollection, Internal.List<number>, Internal.Comparable<Internal.List<number>> {
        abstract iterator(): Internal.DoubleListIterator;
        addAll(arg0: number, arg1: Internal.DoubleList_): boolean;
        abstract containsAll(arg0: Internal.DoubleCollection_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        removeIf(arg0: Internal.DoublePredicate_): boolean;
        of<E>(arg0: E): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        addLast(arg0: number): void;
        reversed(): Internal.SequencedCollection<any>;
        replaceAll(arg0: it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator_): void;
        abstract addElements(arg0: number, arg1: number[]): void;
        abstract rem(arg0: number): boolean;
        abstract add(arg0: number, arg1: number): void;
        of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        forEach(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): void;
        abstract addElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        /**
         * @deprecated
        */
        indexOf(arg0: any): number;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        toDoubleArray(arg0: number[]): number[];
        abstract addAll(arg0: number, arg1: Internal.DoubleCollection_): boolean;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        abstract set(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: any): any;
        /**
         * @deprecated
        */
        lastIndexOf(arg0: any): number;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: number): number;
        abstract getElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        removeFirst(): number;
        /**
         * @deprecated
        */
        unstableSort(arg0: Internal.Comparator_<number>): void;
        listIterator(arg0: number): Internal.ListIterator<any>;
        abstract addAll(arg0: number, arg1: Internal.Collection_<number>): boolean;
        replaceAll(arg0: Internal.DoubleUnaryOperator_): void;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        removeIf(arg0: it.unimi.dsi.fastutil.doubles.DoublePredicate_): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        /**
         * @deprecated
        */
        get(arg0: number): any;
        subList(arg0: number, arg1: number): Internal.List<any>;
        abstract size(): number;
        doubleSpliterator(): Internal.DoubleSpliterator;
        setElements(arg0: number[]): void;
        abstract clear(): void;
        forEach(arg0: Internal.DoubleConsumer_): void;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        abstract getDouble(arg0: number): number;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        abstract addAll(arg0: Internal.DoubleCollection_): boolean;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: any): void;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<number>): void;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        of(...arg0: number[]): this;
        addFirst(arg0: number): void;
        getLast(): number;
        listIterator(): Internal.ListIterator<any>;
        abstract removeDouble(arg0: number): number;
        abstract size(arg0: number): void;
        abstract removeAll(arg0: Internal.DoubleCollection_): boolean;
        getFirst(): number;
        of(): this;
        of<E>(arg0: E, arg1: E): Internal.List<E>;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        unstableSort(arg0: Internal.DoubleComparator_): void;
        sort(arg0: Internal.DoubleComparator_): void;
        addAll(arg0: Internal.DoubleList_): boolean;
        abstract add(arg0: number): boolean;
        abstract removeElements(arg0: number, arg1: number): void;
        /**
         * @deprecated
        */
        remove(arg0: number): any;
        abstract retainAll(arg0: Internal.DoubleCollection_): boolean;
        abstract isEmpty(): boolean;
        abstract addAll(arg0: Internal.Collection_<number>): boolean;
        of(arg0: number, arg1: number): this;
        setElements(arg0: number, arg1: number[]): void;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        of<E>(...arg0: E[]): Internal.List<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        doubleParallelStream(): Internal.DoubleStream;
        setElements(arg0: number, arg1: number[], arg2: number, arg3: number): void;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: number): void;
        of(arg0: number): this;
        doubleStream(): Internal.DoubleStream;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<number>): void;
        abstract toArray(arg0: number[]): number[];
        of(arg0: number, arg1: number, arg2: number): this;
        abstract indexOf(arg0: number): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        abstract contains(arg0: number): boolean;
        doubleIterator(): Internal.DoubleIterator;
        abstract toArray(): any[];
        abstract lastIndexOf(arg0: number): number;
        abstract hashCode(): number;
        abstract compareTo(arg0: Internal.List_<number>): number;
        abstract toDoubleArray(): number[];
        removeLast(): number;
        abstract equals(arg0: any): boolean;
        set elements(arg0: number[])
        get last(): number
        get first(): number
        get empty(): boolean
    }
    type DoubleList_ = DoubleList;
    interface InlineData$InlineDataType <D extends Internal.InlineData<D>> {
        abstract getId(): ResourceLocation;
        abstract getCodec(): Internal.Codec<D>;
        get id(): ResourceLocation
        get codec(): Internal.Codec<D>
    }
    type InlineData$InlineDataType_<D extends Internal.InlineData<D>> = InlineData$InlineDataType<D>;
    class RepulsiveEffect extends Internal.NoMilkEffect {
        constructor()
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
    }
    type RepulsiveEffect_ = RepulsiveEffect;
    class LootTable$Builder implements Internal.FunctionUserBuilder<Internal.LootTable$Builder>, Internal.BuilderAccessor, Internal.LootTableBuilderExtensions, Internal.FabricLootTableBuilder {
        constructor()
        unwrap(): Internal.FunctionUserBuilder<any>;
        build(): Internal.LootTable;
        setParamSet($$0: Internal.LootContextParamSet_): this;
        withPool($$0: Internal.LootPool$Builder_): this;
        unwrap(): this;
        apply($$0: Internal.LootItemFunction$Builder_): this;
        apply<E>($$0: E[], $$1: Internal.Function_<E, Internal.LootItemFunction$Builder>): this;
        modifyPools(modifier: Internal.Consumer_<any>): this;
        setRandomSequence($$0: ResourceLocation_): this;
        port_lib$setId(id: ResourceLocation_): void;
        apply(function_: Internal.LootItemFunction_): this;
        pools(pools: Internal.Collection_<any>): this;
        apply(arg0: Internal.LootItemFunction$Builder_): Internal.FunctionUserBuilder<any>;
        pool(pool: Internal.LootPool_): this;
        apply<E>($$0: Internal.Iterable_<E>, $$1: Internal.Function_<E, Internal.LootItemFunction$Builder>): this;
        apply(functions: Internal.Collection_<any>): this;
        getPools(): Internal.List<any>;
        static copyOf(table: Internal.LootTable_): Internal.LootTable$Builder;
        set paramSet($$0: Internal.LootContextParamSet_)
        set randomSequence($$0: ResourceLocation_)
        get pools(): Internal.List<any>
    }
    type LootTable$Builder_ = LootTable$Builder;
    class ModelLoadingEventDispatcher {
        constructor(loader: Internal.ModelBakery_, plugins: Internal.List_<any>)
        modifyModelBeforeBake(model: Internal.UnbakedModel_, id: ResourceLocation_, textureGetter: Internal.Function_<Internal.Material, Internal.TextureAtlasSprite>, settings: Internal.ModelState_, baker: Internal.ModelBaker_): Internal.UnbakedModel;
        addExtraModels(extraModelConsumer: Internal.Consumer_<ResourceLocation>): void;
        modifyModelAfterBake(model: Internal.BakedModel_, id: ResourceLocation_, sourceModel: Internal.UnbakedModel_, textureGetter: Internal.Function_<Internal.Material, Internal.TextureAtlasSprite>, settings: Internal.ModelState_, baker: Internal.ModelBaker_): Internal.BakedModel;
        loadModel(id: ResourceLocation_): boolean;
        modifyModelOnLoad(id: ResourceLocation_, model: Internal.UnbakedModel_): Internal.UnbakedModel;
    }
    type ModelLoadingEventDispatcher_ = ModelLoadingEventDispatcher;
    class ItemJewelerHammer extends Internal.PickaxeItem {
        constructor(tier: Internal.Tier_, damageMod: number, attackSpeedMod: number, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static shouldFailToBreak(player: Internal.Player_, state: Internal.BlockState_, pos: BlockPos_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemJewelerHammer_ = ItemJewelerHammer;
    interface TypeTemplate {
        toSimpleType(): com.mojang.datafixers.types.Type<any>;
        abstract size(): number;
        abstract apply(arg0: Internal.TypeFamily_): Internal.TypeFamily;
        abstract findFieldOrType<A, B>(arg0: number, arg1: string, arg2: com.mojang.datafixers.types.Type_<A>, arg3: com.mojang.datafixers.types.Type_<B>): Internal.Either<Internal.TypeTemplate, Internal.Type$FieldNotFoundException>;
        abstract applyO<A, B>(arg0: Internal.FamilyOptic_<A, B>, arg1: com.mojang.datafixers.types.Type_<A>, arg2: com.mojang.datafixers.types.Type_<B>): Internal.FamilyOptic<A, B>;
        abstract hmap(arg0: Internal.TypeFamily_, arg1: Internal.IntFunction_<Internal.RewriteResult<any, any>>): Internal.IntFunction<Internal.RewriteResult<any, any>>;
    }
    type TypeTemplate_ = TypeTemplate;
    class PlacardBlock extends Internal.FaceAttachedHorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.PlacardBlockEntity>, Internal.SpecialBlockItemRequirement {
        constructor(p_53182_: Internal.BlockBehaviour$Properties_)
        static connectedDirection(state: Internal.BlockState_): Internal.Direction;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.PlacardBlockEntity;
        getRequiredItems(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.PlacardBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.PlacardBlockEntity;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static canAttachLenient(pReader: Internal.LevelReader_, pPos: BlockPos_, pDirection: Internal.Direction_): boolean;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static updateNeighbours(pState: Internal.BlockState_, pLevel: Internal.Level_, pPos: BlockPos_): void;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.PlacardBlockEntity>): void;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.PlacardBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.PlacardBlockEntity>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockEntityClass(): typeof Internal.PlacardBlockEntity
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.PlacardBlockEntity>
        static readonly POWERED: Internal.BooleanProperty;
    }
    type PlacardBlock_ = PlacardBlock;
    class BlastingRecipe extends Internal.AbstractCookingRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CookingBookCategory_, $$3: Internal.Ingredient_, $$4: Internal.ItemStack_, $$5: number, $$6: number)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type BlastingRecipe_ = BlastingRecipe;
    class SmithingTrimRecipe$Serializer implements Internal.RecipeSerializer<Internal.SmithingTrimRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): Internal.SmithingTrimRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): Internal.SmithingTrimRecipe;
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: Internal.SmithingTrimRecipe_): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type SmithingTrimRecipe$Serializer_ = SmithingTrimRecipe$Serializer;
    class BlockStateMatchTest extends Internal.RuleTest implements Internal.BlockStateMatchTestAccessor {
        constructor($$0: Internal.BlockState_)
        getBlockState(): Internal.BlockState;
        get blockState(): Internal.BlockState
        static readonly CODEC: Internal.Codec<Internal.BlockStateMatchTest>;
    }
    type BlockStateMatchTest_ = BlockStateMatchTest;
    class CardboardHelmetItem extends Internal.CardboardArmorItem {
        constructor(type: Internal.ArmorItem$Type_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CardboardHelmetItem_ = CardboardHelmetItem;
    class ExecutionClientView {
        constructor(isStackClear: boolean, resolutionType: Internal.ResolvedPatternType_, stackDescs: Internal.List_<Internal.CompoundTag>, ravenmind: Internal.CompoundTag_)
        getRavenmind(): Internal.CompoundTag;
        component3(): Internal.List<Internal.CompoundTag>;
        component1(): boolean;
        getResolutionType(): Internal.ResolvedPatternType;
        component4(): Internal.CompoundTag;
        component2(): Internal.ResolvedPatternType;
        getStackDescs(): Internal.List<Internal.CompoundTag>;
        static copy$default(arg0: Internal.ExecutionClientView_, arg1: boolean, arg2: Internal.ResolvedPatternType_, arg3: Internal.List_<any>, arg4: Internal.CompoundTag_, arg5: number, arg6: any): Internal.ExecutionClientView;
        copy(isStackClear: boolean, resolutionType: Internal.ResolvedPatternType_, stackDescs: Internal.List_<Internal.CompoundTag>, ravenmind: Internal.CompoundTag_): this;
        isStackClear(): boolean;
        get ravenmind(): Internal.CompoundTag
        get resolutionType(): Internal.ResolvedPatternType
        get stackDescs(): Internal.List<Internal.CompoundTag>
        get stackClear(): boolean
    }
    type ExecutionClientView_ = ExecutionClientView;
    interface PBRDumpable extends Internal.Dumpable {
        abstract getDefaultDumpLocation(): ResourceLocation;
        abstract dumpContents(arg0: ResourceLocation_, arg1: Internal.Path_): void;
        get defaultDumpLocation(): ResourceLocation
    }
    type PBRDumpable_ = PBRDumpable;
    class MoltenNetheriteFluid$Flowing extends Internal.MoltenNetheriteFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenNetheriteFluid$Flowing_ = MoltenNetheriteFluid$Flowing;
    class EmptyEmiStack$EmptyEntry extends any {
        constructor()
    }
    type EmptyEmiStack$EmptyEntry_ = EmptyEmiStack$EmptyEntry;
    class ClientboundHorseScreenOpenPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: number, $$2: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getSize(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntityId(): number;
        getContainerId(): number;
        isSkippable(): boolean;
        get size(): number
        get entityId(): number
        get containerId(): number
        get skippable(): boolean
    }
    type ClientboundHorseScreenOpenPacket_ = ClientboundHorseScreenOpenPacket;
    abstract class ArgumentBuilder <S, T extends Internal.ArgumentBuilder<S, T>> {
        constructor()
        redirect(arg0: Internal.CommandNode_<S>): T;
        abstract build(): Internal.CommandNode<S>;
        then(arg0: Internal.CommandNode_<S>): T;
        redirect(arg0: Internal.CommandNode_<S>, arg1: Internal.SingleRedirectModifier_<S>): T;
        getArguments(): Internal.Collection<Internal.CommandNode<S>>;
        then(arg0: Internal.ArgumentBuilder_<S, any>): T;
        fork(arg0: Internal.CommandNode_<S>, arg1: Internal.RedirectModifier_<S>): T;
        getRedirectModifier(): Internal.RedirectModifier<S>;
        getRequirement(): Internal.Predicate<S>;
        requires(arg0: Internal.Predicate_<S>): T;
        forward(arg0: Internal.CommandNode_<S>, arg1: Internal.RedirectModifier_<S>, arg2: boolean): T;
        executes(arg0: Internal.Command_<S>): T;
        getRedirect(): Internal.CommandNode<S>;
        isFork(): boolean;
        getCommand(): Internal.Command<S>;
        get "arguments"(): Internal.Collection<Internal.CommandNode<S>>
        get redirectModifier(): Internal.RedirectModifier<S>
        get requirement(): Internal.Predicate<S>
        get redirect(): Internal.CommandNode<S>
        get fork(): boolean
        get command(): Internal.Command<S>
    }
    type ArgumentBuilder_<S, T extends Internal.ArgumentBuilder<S, T>> = ArgumentBuilder<S, T>;
    class PatternProviderBlockEntity extends Internal.AENetworkBlockEntity implements Internal.PatternProviderLogicHost {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getTerminalPatternInventory(): Internal.InternalInventory;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getConfigManager(): Internal.IConfigManager;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getLogic(): Internal.PatternProviderLogic;
        getTerminalGroup(): Internal.PatternContainerGroup;
        getGrid(): Internal.IGrid;
        onLoad(): void;
        getTerminalSortOrder(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getMainMenuIcon(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getTerminalIcon(): Internal.AEItemKey;
        getTargets(): Internal.EnumSet<Internal.Direction>;
        hasCustomName(): boolean;
        returnToMainMenu(player: Internal.Player_, subMenu: Internal.ISubMenu_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isVisibleInTerminal(): boolean;
        openMenu(player: Internal.Player_, locator: Internal.MenuLocator_): void;
        setPriority(newValue: number): void;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getPriority(): number;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get terminalPatternInventory(): Internal.InternalInventory
        get configManager(): Internal.IConfigManager
        get logic(): Internal.PatternProviderLogic
        get terminalGroup(): Internal.PatternContainerGroup
        get grid(): Internal.IGrid
        get terminalSortOrder(): number
        get gridNode(): Internal.IGridNode
        get mainMenuIcon(): Internal.ItemStack
        get terminalIcon(): Internal.AEItemKey
        get targets(): Internal.EnumSet<Internal.Direction>
        get visibleInTerminal(): boolean
        set priority(newValue: number)
        get actionableNode(): Internal.IGridNode
        get priority(): number
        set owner(owner: Internal.Player_)
    }
    type PatternProviderBlockEntity_ = PatternProviderBlockEntity;
    interface IDisplayModifierRecipe extends Internal.IModifierRecipe {
        withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_): Internal.ItemStack;
        abstract getDisplayResult(): Internal.ModifierEntry;
        getMaxLevel(): number;
        abstract getDisplayItems(arg0: number): Internal.List<Internal.ItemStack>;
        abstract getInputCount(): number;
        abstract getToolWithoutModifier(): Internal.List<Internal.ItemStack>;
        getSlots(): Internal.SlotType$SlotCount;
        withModifiers(stack: Internal.ItemStack_, match: Internal.ModifierMatch_, newModifier: Internal.ModifierEntry_, persistentDataConsumer: Internal.Consumer_<Internal.ModDataNBT>): Internal.ItemStack;
        getRequirementsError(): string;
        getSlotType(): Internal.SlotType;
        isIncremental(): boolean;
        hasRequirements(): boolean;
        abstract getToolWithModifier(): Internal.List<Internal.ItemStack>;
        getModifier(): Internal.Modifier;
        get displayResult(): Internal.ModifierEntry
        get maxLevel(): number
        get inputCount(): number
        get toolWithoutModifier(): Internal.List<Internal.ItemStack>
        get slots(): Internal.SlotType$SlotCount
        get requirementsError(): string
        get slotType(): Internal.SlotType
        get incremental(): boolean
        get toolWithModifier(): Internal.List<Internal.ItemStack>
        get modifier(): Internal.Modifier
        readonly MAP_TOOL_FOR_RENDERING: Internal.Function<Internal.Item, Internal.ItemStack>;
    }
    type IDisplayModifierRecipe_ = IDisplayModifierRecipe;
    class TextWidget extends Internal.Widget {
        constructor(text: Internal.FormattedCharSequence_, x: number, y: number, color: number, shadow: boolean)
        verticalAlign(alignment: Internal.TextWidget$Alignment_): this;
        horizontalAlign(alignment: Internal.TextWidget$Alignment_): this;
    }
    type TextWidget_ = TextWidget;
    interface BooleanUnaryOperator extends Internal.UnaryOperator<boolean> {
        andThen<V>(arg0: Internal.Function_<boolean, V>): Internal.Function<boolean, V>;
        identity(): this;
        compose<V>(arg0: Internal.Function_<V, boolean>): Internal.Function<V, boolean>;
        /**
         * @deprecated
        */
        apply(arg0: any): any;
        abstract apply(arg0: boolean): boolean;
        negation(): this;
        /**
         * @deprecated
        */
        apply(arg0: boolean): boolean;
        (arg0: boolean): boolean;
    }
    type BooleanUnaryOperator_ = BooleanUnaryOperator;
    interface ResourceLocationExtensions {
        compareNamespaced(o: ResourceLocation_): number;
    }
    type ResourceLocationExtensions_ = ResourceLocationExtensions;
    class LecternBlockEntity extends Internal.BlockEntity implements Internal.MenuProvider, Internal.Clearable {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        createMenu($$0: number, $$1: Internal.Inventory_, $$2: Internal.Player_): Internal.AbstractContainerMenu;
        getBook(): Internal.ItemStack;
        shouldCloseCurrentScreen(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        setBook($$0: Internal.ItemStack_, $$1: Internal.Player_): void;
        getPage(): number;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setBook($$0: Internal.ItemStack_): void;
        getRedstoneSignal(): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        clearContent(): void;
        hasBook(): boolean;
        get displayName(): net.minecraft.network.chat.Component
        get book(): Internal.ItemStack
        get page(): number
        set book($$0: Internal.ItemStack_)
        get redstoneSignal(): number
        static readonly NUM_DATA: 1;
        static readonly DATA_PAGE: 0;
        static readonly NUM_SLOTS: 1;
        static readonly SLOT_BOOK: 0;
    }
    type LecternBlockEntity_ = LecternBlockEntity;
    class CardboardSwordItem extends Internal.SwordItem implements Internal.CustomEnchantingBehaviorItem {
        constructor(pProperties: Internal.Item$Properties_)
        static knockback(target: Internal.LivingEntity_, knockbackStrength: number, yRot: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        canApplyAtEnchantingTable(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static cardboardSwordsMakeNoiseOnClick(player: Internal.Player_, level: Internal.Level_, hand: Internal.InteractionHand_, pos: BlockPos_, direction: Internal.Direction_): Internal.InteractionResult;
        setArmorProtection(armorProtection: number): void;
        isBookEnchantable(stack: Internal.ItemStack_, book: Internal.ItemStack_): boolean;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static cardboardSwordsCannotHurtYou(event: Internal.LivingAttackEvent_): void;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CardboardSwordItem_ = CardboardSwordItem;
    class EndDragonFight {
        constructor($$0: Internal.ServerLevel_, $$1: number, $$2: Internal.EndDragonFight$Data_)
        constructor($$0: Internal.ServerLevel_, $$1: number, $$2: Internal.EndDragonFight$Data_, $$3: BlockPos_)
        getCrystalsAlive(): number;
        resetSpikeCrystals(): void;
        updateDragon($$0: Internal.EnderDragon_): void;
        /**
         * @deprecated
        */
        removeAllGateways(): void;
        saveData(): Internal.EndDragonFight$Data;
        setDragonKilled($$0: Internal.EnderDragon_): void;
        getDragonUUID(): Internal.UUID;
        tick(): void;
        hasPreviouslyKilledDragon(): boolean;
        onCrystalDestroyed($$0: Internal.EndCrystal_, $$1: DamageSource_): void;
        tryRespawn(): void;
        /**
         * @deprecated
        */
        skipArenaLoadedCheck(): void;
        get crystalsAlive(): number
        set dragonKilled($$0: Internal.EnderDragon_)
        get dragonUUID(): Internal.UUID
        static readonly DRAGON_SPAWN_Y: 128;
        static readonly TIME_BETWEEN_PLAYER_SCANS: 20;
        static readonly ARENA_TICKET_LEVEL: 9;
    }
    type EndDragonFight_ = EndDragonFight;
    interface BooleanListIterator extends Internal.ListIterator<boolean>, Internal.BooleanBidirectionalIterator {
        /**
         * @deprecated
        */
        add(arg0: any): void;
        add(arg0: boolean): void;
        set(arg0: boolean): void;
        /**
         * @deprecated
        */
        forEachRemaining(arg0: Internal.Consumer_<boolean>): void;
        abstract nextIndex(): number;
        forEachRemaining(arg0: any): void;
        /**
         * @deprecated
        */
        next(): any;
        /**
         * @deprecated
        */
        set(arg0: any): void;
        skip(arg0: number): number;
        abstract nextBoolean(): boolean;
        abstract previousBoolean(): boolean;
        remove(): void;
        abstract hasPrevious(): boolean;
        /**
         * @deprecated
        */
        set(arg0: boolean): void;
        back(arg0: number): number;
        abstract hasNext(): boolean;
        /**
         * @deprecated
        */
        previous(): any;
        /**
         * @deprecated
        */
        add(arg0: boolean): void;
        abstract previousIndex(): number;
        forEachRemaining(arg0: it.unimi.dsi.fastutil.booleans.BooleanConsumer_): void;
    }
    type BooleanListIterator_ = BooleanListIterator;
    class Dolphin extends Internal.WaterAnimal {
        constructor($$0: Internal.EntityType_<Internal.Dolphin>, $$1: Internal.Level_)
        gotFish(): boolean;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setMoisntessLevel($$0: number): void;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setTreasurePos($$0: BlockPos_): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        getMoistnessLevel(): number;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        setGotFish($$0: boolean): void;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        getTreasurePos(): BlockPos;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        set moisntessLevel($$0: number)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        set treasurePos($$0: BlockPos_)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get moistnessLevel(): number
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        set gotFish($$0: boolean)
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get treasurePos(): BlockPos
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly ALLOWED_ITEMS: Internal.Predicate<Internal.ItemEntity>;
        static readonly TOTAL_AIR_SUPPLY: 4800;
    }
    type Dolphin_ = Dolphin;
    class MouseHandler implements net.blay09.mods.balm.mixin.MouseHandlerAccessor, Internal.AccessorMouseHandler, Internal.MouseHandlerAccessor {
        constructor($$0: Internal.Minecraft_)
        isRightPressed(): boolean;
        isMiddlePressed(): boolean;
        getMouseX(): number;
        handler$bfb000$balm$onMovePost(screen: Internal.Screen_, mouseX: number, mouseY: number, dragX: number, dragY: number, callbackInfo: Internal.CallbackInfo_): void;
        getMouseY(): number;
        setIgnoreFirstMove(): void;
        grabMouse(): void;
        isLeftPressed(): boolean;
        handler$zlj000$ae2$onScrollWithoutScreen(windowId: number, x: number, y: number, ci: Internal.CallbackInfo_, verticalAmount: number): void;
        xpos(): number;
        handler$zpl000$architectury$onMouseScrolledPost(handle: number, xOffset: number, yOffset: number, info: Internal.CallbackInfo_, amount: number, x: number, y: number): void;
        create$setXPos(arg0: number): void;
        turnPlayer(): void;
        releaseMouse(): void;
        handler$zpl000$architectury$onRawMouseScrolled(handle: number, xOffset: number, yOffset: number, info: Internal.CallbackInfo_, amount: number): void;
        isMouseGrabbed(): boolean;
        hex$setAccumulatedScroll(arg0: number): void;
        handler$ecd000$kuma_api$keyPress(window: number, button: number, press: number, flags: number, callbackInfo: Internal.CallbackInfo_): void;
        setup($$0: number): void;
        handler$zpl000$architectury$onRawMouseClicked(handle: number, button: number, action: number, mods: number, info: Internal.CallbackInfo_): void;
        hex$getAccumulatedScroll(): number;
        handler$zpl000$architectury$onMouseScrolled(handle: number, xOffset: number, yOffset: number, info: Internal.CallbackInfo_, amount: number, x: number, y: number): void;
        ypos(): number;
        cursorEntered(): void;
        create$setYPos(arg0: number): void;
        handler$zpl000$architectury$onRawMouseClickedPost(handle: number, button: number, action: number, mods: number, info: Internal.CallbackInfo_): void;
        handler$bfb000$balm$onMovePre(screen: Internal.Screen_, mouseX: number, mouseY: number, dragX: number, dragY: number, callbackInfo: Internal.CallbackInfo_): void;
        get rightPressed(): boolean
        get middlePressed(): boolean
        get mouseX(): number
        get mouseY(): number
        get leftPressed(): boolean
        get mouseGrabbed(): boolean
        set up($$0: number)
        mouseGrabbed: boolean;
    }
    type MouseHandler_ = MouseHandler;
    interface GuiGraphicsExtension {
        renderComponentTooltip(font: net.minecraft.client.gui.Font_, tooltips: Internal.List_<Internal.FormattedText>, mouseX: number, mouseY: number, stack: Internal.ItemStack_): void;
    }
    type GuiGraphicsExtension_ = GuiGraphicsExtension;
    interface InstanceType <I extends Internal.Instance> {
        abstract cullShader(): ResourceLocation;
        abstract layout(): Internal.Layout;
        abstract vertexShader(): ResourceLocation;
        abstract writer(): Internal.InstanceWriter<I>;
        abstract create(arg0: Internal.InstanceHandle_): I;
    }
    type InstanceType_<I extends Internal.Instance> = InstanceType<I>;
    class NozzleBlock extends Internal.WrenchableDirectionalBlock implements Internal.IBE<Internal.NozzleBlockEntity> {
        constructor(p_i48415_1_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.NozzleBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityClass(): typeof Internal.NozzleBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.NozzleBlockEntity>;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.NozzleBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.NozzleBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.NozzleBlockEntity>): void;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.NozzleBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.NozzleBlockEntity>
    }
    type NozzleBlock_ = NozzleBlock;
    class Button extends Internal.AbstractButton implements Internal.ButtonWidgetAccessor {
        charTyped($$0: string, $$1: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        moveTo(x: number, y: number): void;
        remove(): void;
        isInBoundingBox(x: number, y: number): boolean;
        hasParent(): boolean;
        fullSize(): Internal.Size;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        mouseMoved($$0: number, $$1: number): void;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        setPosition($$0: number, $$1: number): void;
        method_47399($$0: Internal.NarrationElementOutput_): void;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        getCurrentFocusPath(): Internal.ComponentPath;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        static builder($$0: net.minecraft.network.chat.Component_, $$1: Internal.Button$OnPress_): Internal.Button$Builder;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): Internal.ParentComponent;
        owo$setOnPress(arg0: Internal.Button$OnPress_): void;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        get currentFocusPath(): Internal.ComponentPath
        static readonly DEFAULT_WIDTH: 150;
        onPress: Internal.Button$OnPress;
        static readonly DEFAULT_HEIGHT: 20;
        static readonly SMALL_WIDTH: 120;
    }
    type Button_ = Button;
    class PackageFilterItem extends Internal.FilterItem {
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        shouldCloseCurrentScreen(): boolean;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        canCopyToItem(item: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PackageFilterItem_ = PackageFilterItem;
    class FluidValveBlockEntity extends Internal.KineticBlockEntity implements Internal.PipeAttachmentBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        static getAttachments(be: Internal.BlockEntity_): any[];
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type FluidValveBlockEntity_ = FluidValveBlockEntity;
    interface Double2DoubleFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.DoubleUnaryOperator {
        compose(arg0: Internal.DoubleUnaryOperator_): Internal.DoubleUnaryOperator;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Double2ObjectFunction<T>;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2DoubleFunction;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2DoubleFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        apply(arg0: number): number;
        identity(): this;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Double2CharFunction;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2DoubleFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2DoubleFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(arg0: number): void;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2DoubleFunction<T>;
        getOrDefault(arg0: number, arg1: number): number;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2DoubleFunction;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Double2ByteFunction;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Double2LongFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2DoubleFunction;
        applyAsDouble(arg0: number): number;
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Double2ShortFunction;
        containsKey(arg0: number): boolean;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Double2IntFunction;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Double2ReferenceFunction<T>;
        size(): number;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2DoubleFunction;
        andThen(arg0: Internal.DoubleUnaryOperator_): Internal.DoubleUnaryOperator;
        clear(): void;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        remove(arg0: number): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        abstract get(arg0: number): number;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Double2FloatFunction;
        (arg0: number): number;
    }
    type Double2DoubleFunction_ = Double2DoubleFunction;
}
declare namespace dev.lambdaurora.lambdynlights {
    /**
     * @deprecated
     * This class is marked to be removed in future!
    */
    interface DynamicLightSource extends Internal.EntityDynamicLightSourceBehavior {
        abstract getDynamicLightPrevZ(): number;
        abstract getDynamicLightLevel(): Internal.Level;
        abstract setLuminance(arg0: number): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        abstract getLastDynamicLuminance(): number;
        abstract getDynamicLightX(): number;
        abstract getDynamicLightY(): number;
        isDynamicLightEnabled(): boolean;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        abstract getDynamicLightZ(): number;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        abstract getDynamicLightPrevY(): number;
        abstract getDynamicLightPrevX(): number;
        tickEntity(entity: Internal.Entity_): void;
        abstract lambdynlights$setTrackedLitChunkPos(arg0: Internal.LongSet_): void;
        abstract dynamicLightTick(): void;
        abstract lambdynlights$getTrackedLitChunkPos(): Internal.LongSet;
        abstract updateDynamicLightPreviousCoordinates(): void;
        abstract setLastDynamicLuminance(arg0: number): void;
        abstract resetDynamicLight(): void;
        setDynamicLightEnabled(enabled: boolean): void;
        abstract getLuminance(): number;
        get dynamicLightPrevZ(): number
        get dynamicLightLevel(): Internal.Level
        set luminance(arg0: number)
        get lastDynamicLuminance(): number
        get dynamicLightX(): number
        get dynamicLightY(): number
        get dynamicLightEnabled(): boolean
        get dynamicLightZ(): number
        get dynamicLightPrevY(): number
        get dynamicLightPrevX(): number
        set lastDynamicLuminance(arg0: number)
        set dynamicLightEnabled(enabled: boolean)
        get luminance(): number
    }
    type DynamicLightSource_ = DynamicLightSource;
}
declare namespace at.petrak.hexcasting.mixin.accessor {
    interface AccessorEntity {
        abstract hex$markHurt(): void;
        (): void;
    }
    type AccessorEntity_ = AccessorEntity;
}
